/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.tier1234.better_deco.Config;
import net.tier1234.better_deco.block.entity.ModBlockEntities;
import net.tier1234.better_deco.block.entity.custom.FluidContainerBlockEntity;
import net.tier1234.better_deco.screen.custom.SinkMenu;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class KitchenSinkBlockEntity
extends FluidContainerBlockEntity
implements MenuProvider {
    public KitchenSinkBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.KITCHEN_SINK.get(), pos, state, Config.getSinkCapacityBuckets() * 1000);
    }

    public boolean addFluid(Fluid fluid) {
        int current = this.getFluidStack().getAmount();
        int max = this.getCapacity();
        if ((this.isEmpty() || this.getFluidStack().getFluid() == fluid) && current + 1000 <= max) {
            this.setFluidStack(new FluidStack(fluid, current + 1000));
            return true;
        }
        return false;
    }

    public void removeFluid(int amount) {
        int remaining = this.getFluidStack().getAmount() - amount;
        this.setFluidStack(new FluidStack(this.getFluidStack().getFluid(), Math.max(remaining, 0)));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.better_deco.sink");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new SinkMenu(i, inventory, this);
    }
}

