/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.creative_tabs;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.tier1234.better_deco.creative_tabs.BundledTabs;
import net.tier1234.better_deco.creative_tabs.ModBundledTabs;
import net.tier1234.better_deco.creative_tabs.ModCreativeTabs;
import net.tier1234.better_deco.mixin.access.CreativeModeInventoryScreenAccessor;
import net.tier1234.better_deco.mixin.access.ScreenAccessor;

public class BundledTabSelector {
    private static final ResourceLocation SELECTOR_BAR = ResourceLocation.fromNamespaceAndPath((String)"better_deco", (String)"textures/gui/tab_selector/tab_selector.png");
    private static final int VISIBLE_CATEGORIES = 5;
    private static BundledTabSelector instance;
    private int guiLeft;
    private int guiTop;
    private int scroll;
    private AbstractWidget scrollUpButton;
    private AbstractWidget scrollDownButton;
    private List<BundledTabs> bundles = null;
    private CreativeModeTab lastTab;

    public static BundledTabSelector bootstrap() {
        if (instance == null) {
            instance = new BundledTabSelector();
        }
        return instance;
    }

    private BundledTabSelector() {
    }

    public void init(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            if (this.bundles == null) {
                ArrayList<BundledTabs> bundles = new ArrayList<BundledTabs>(ModBundledTabs.getFilters());
                Collections.reverse(bundles);
                this.bundles = bundles;
            }
            this.guiLeft = creativeScreen.getGuiLeft();
            this.guiTop = creativeScreen.getGuiTop();
            this.injectWidgets(creativeScreen, widget -> ((ScreenAccessor)screen).callAddRenderableWidget(widget));
        }
    }

    public void renderBackground(ContainerScreenEvent.Render.Background event) {
        AbstractContainerScreen screen = event.getContainerScreen();
        GuiGraphics graphics = event.getGuiGraphics();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            CreativeModeTab tab = CreativeModeInventoryScreenAccessor.getSelectedTab();
            graphics.pose().pushPose();
            graphics.pose().translate(0.0, 0.0, 0.0);
            if (this.isValidTab(tab)) {
                graphics.blit(RenderType.GUI_TEXTURED, SELECTOR_BAR, this.guiLeft - 35, this.guiTop + 2, 11.0f, 3.0f, 34, 121, 256, 256);
            }
            if (this.lastTab != tab) {
                this.onSwitchCreativeTab(tab, creativeScreen);
                this.lastTab = tab;
            }
            graphics.pose().popPose();
        }
    }

    public void onClose(ScreenEvent.Closing event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            this.scrollUpButton = null;
            this.scrollDownButton = null;
            this.bundles.forEach(bundle -> {
                bundle.setContentTab(null);
                bundle.deselect();
            });
        }
    }

    private void injectWidgets(CreativeModeInventoryScreen screen, Consumer<AbstractWidget> widgets) {
        this.bundles.forEach(category -> {
            Tab tab = new Tab(this.guiLeft - 26, this.guiTop + 7, (BundledTabs)category, button -> {
                if (category.isSelected()) {
                    category.deselect();
                } else {
                    this.bundles.forEach(BundledTabs::deselect);
                    category.select();
                }
                this.updateItems(screen);
            });
            tab.visible = false;
            widgets.accept((AbstractWidget)tab);
        });
        this.scrollUpButton = new ScrollButton(this.guiLeft - 27, this.guiTop + 6, 50, button -> {
            if (this.scroll > 0) {
                --this.scroll;
            }
            this.updateWidgets();
        });
        this.scrollDownButton = new ScrollButton(this.guiLeft - 27, this.guiTop + 110, 70, button -> {
            if (this.scroll < this.getMaxScroll()) {
                ++this.scroll;
            }
            this.updateWidgets();
        });
        widgets.accept(this.scrollUpButton);
        widgets.accept(this.scrollDownButton);
        this.updateWidgets();
        this.onSwitchCreativeTab(CreativeModeInventoryScreenAccessor.getSelectedTab(), screen);
    }

    private int getMaxScroll() {
        return Math.max(0, this.bundles.size() - 5);
    }

    private void updateItems(CreativeModeInventoryScreen screen) {
        HashSet seenItems = new HashSet();
        LinkedHashSet displayItems = new LinkedHashSet();
        boolean hasSelected = this.bundles.stream().anyMatch(BundledTabs::isSelected);
        ModCreativeTabs.BETTER_DECO.get().getDisplayItems().forEach(stack -> {
            if (!hasSelected) {
                if (!seenItems.contains(stack)) {
                    displayItems.add(stack.copy());
                    seenItems.add(stack);
                }
            } else {
                this.bundles.stream().filter(BundledTabs::isSelected).forEach(bundle -> {
                    if (!seenItems.contains(stack) && bundle.contains((ItemStack)stack)) {
                        displayItems.add(stack.copy());
                        seenItems.add(stack);
                    }
                });
            }
        });
        NonNullList items = ((CreativeModeInventoryScreen.ItemPickerMenu)screen.getMenu()).items;
        items.clear();
        items.addAll(displayItems);
        ((CreativeModeInventoryScreen.ItemPickerMenu)screen.getMenu()).scrollTo(0.0f);
    }

    private void updateWidgets() {
        this.bundles.forEach(bundle -> bundle.setVisible(false));
        for (int i = this.scroll; i < this.scroll + 5 && i < this.bundles.size(); ++i) {
            BundledTabs bundle2 = this.bundles.get(i);
            bundle2.setY(this.guiTop + 18 * (i - this.scroll) + 18);
            bundle2.setVisible(true);
        }
        boolean isValidTab = this.isValidTab(CreativeModeInventoryScreenAccessor.getSelectedTab());
        this.scrollUpButton.visible = isValidTab && this.scroll > 0;
        this.scrollDownButton.visible = isValidTab && this.scroll < this.getMaxScroll();
    }

    private void onSwitchCreativeTab(CreativeModeTab tab, CreativeModeInventoryScreen screen) {
        if (this.isValidTab(tab)) {
            this.updateWidgets();
            this.updateItems(screen);
        } else {
            this.scrollUpButton.visible = false;
            this.scrollDownButton.visible = false;
            this.bundles.forEach(bundle -> bundle.setVisible(false));
        }
    }

    private boolean isValidTab(CreativeModeTab tab) {
        return tab == ModCreativeTabs.BETTER_DECO.get();
    }

    public static class ScrollButton
    extends Button {
        private final int uOffset;

        public ScrollButton(int x, int y, int uOffset, Button.OnPress onPress) {
            super(x, y, 18, 20, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
            this.uOffset = uOffset;
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int textureY = this.isHovered ? 17 : 6;
            graphics.blit(RenderType.GUI_TEXTURED, SELECTOR_BAR, this.getX(), this.getY(), (float)this.uOffset, (float)textureY, 18, 9, 256, 256);
        }
    }

    public static class Tab
    extends Button {
        private final BundledTabs bundle;

        protected Tab(int x, int y, BundledTabs bundle, Button.OnPress onPress) {
            super(x, y, 16, 16, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
            this.bundle = bundle;
            bundle.setContentTab(this);
            this.setTooltip(Tooltip.create((Component)bundle.tooltip));
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.renderSelected(graphics);
            graphics.renderItem(this.bundle.getIcon(), this.getX(), this.getY());
            this.renderHighlight(graphics);
        }

        private void renderSelected(GuiGraphics graphics) {
            if (this.bundle.isSelected()) {
                graphics.blit(RenderType.GUI_TEXTURED, SELECTOR_BAR, this.getX() - 7, this.getY() - 1, 64.0f, 29.0f, 30, 19, 256, 256);
            }
        }

        private void renderHighlight(GuiGraphics graphics) {
            if (this.isHovered() && !this.bundle.isSelected()) {
                graphics.pose().pushPose();
                graphics.pose().translate(0.0, 0.0, 200.0);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                graphics.blit(RenderType.GUI_TEXTURED, SELECTOR_BAR, this.getX(), this.getY(), 48.0f, 48.0f, 16, 16, 256, 256);
                RenderSystem.disableBlend();
                graphics.pose().popPose();
            }
        }
    }
}

