/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.block.entity.custom.DigitalClockBlockEntity;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class DigitalClockBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public DigitalClockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.SOUTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return null;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] FRAME_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)4.5, (double)0.0, (double)9.0, (double)11.5, (double)0.5, (double)9.5), Direction.SOUTH));
        VoxelShape[] FRAME_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)4.5, (double)4.0, (double)9.0, (double)11.5, (double)4.5, (double)9.5), Direction.SOUTH));
        VoxelShape[] FRAME_BACK = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)4.5, (double)0.0, (double)7.0, (double)11.5, (double)4.3, (double)9.0), Direction.SOUTH));
        VoxelShape[] FRAME_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)4.0, (double)0.5, (double)9.0, (double)4.5, (double)4.0, (double)9.5), Direction.SOUTH));
        VoxelShape[] FRAME_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)11.5, (double)0.5, (double)9.0, (double)12.0, (double)4.0, (double)9.5), Direction.SOUTH));
        VoxelShape[] FRAME_BACK_2 = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)4.2, (double)0.3, (double)7.0, (double)4.5, (double)4.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] FRAME_BACK_3 = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)11.5, (double)0.3, (double)7.0, (double)11.8, (double)4.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] BUTTON_1 = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)5.0, (double)4.3, (double)8.0, (double)5.4, (double)4.5, (double)8.4), Direction.SOUTH));
        VoxelShape[] BUTTON_2 = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)6.0, (double)4.3, (double)8.0, (double)6.4, (double)4.5, (double)8.4), Direction.SOUTH));
        VoxelShape[] BUTTON_3 = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)7.0, (double)4.3, (double)8.0, (double)7.4, (double)4.5, (double)8.4), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(FRAME_BOTTOM[direction.get2DDataValue()]);
            shapes.add(FRAME_TOP[direction.get2DDataValue()]);
            shapes.add(FRAME_BACK[direction.get2DDataValue()]);
            shapes.add(FRAME_LEFT[direction.get2DDataValue()]);
            shapes.add(FRAME_RIGHT[direction.get2DDataValue()]);
            shapes.add(FRAME_BACK_2[direction.get2DDataValue()]);
            shapes.add(FRAME_BACK_3[direction.get2DDataValue()]);
            shapes.add(BUTTON_1[direction.get2DDataValue()]);
            shapes.add(BUTTON_2[direction.get2DDataValue()]);
            shapes.add(BUTTON_3[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            BlockEntity blockEntity;
            DyeItem dyeItem = (DyeItem)item;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof DigitalClockBlockEntity) {
                DigitalClockBlockEntity digitalClock = (DigitalClockBlockEntity)blockEntity;
                digitalClock.setTextColor(dyeItem.getDyeColor());
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DigitalClockBlockEntity(pos, state);
    }
}

