/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.Config;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.block.custom.ModBlockStateProperties;
import net.tier1234.better_deco.block.entity.custom.KitchenSinkBlockEntity;
import net.tier1234.better_deco.util.FluidInteractionUtil;
import net.tier1234.better_deco.util.VoxelShapeHelper;
import org.jetbrains.annotations.Nullable;

public class KitchenSinkBlock
extends FurnitureHorizontalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HAS_WATER = ModBlockStateProperties.HAS_WATER;
    private final ImmutableMap<BlockState, VoxelShape> shapesByState;

    public KitchenSinkBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DIRECTION, (Comparable)Direction.SOUTH)).setValue((Property)HAS_WATER, (Comparable)Boolean.valueOf(false)));
        this.shapesByState = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return null;
    }

    public ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState s : states) {
            Direction dir = (Direction)s.getValue((Property)DIRECTION);
            VoxelShape lower = this.createShape(0.0, 0.0, 0.0, 16.0, 9.0, 15.0, dir);
            VoxelShape upper = this.createShape(0.0, 9.0, 0.0, 16.0, 16.0, 16.0, dir);
            builder.put((Object)s, (Object)VoxelShapeHelper.combineAll(Arrays.asList(lower, upper)));
        }
        return builder.build();
    }

    private VoxelShape createShape(double x1, double y1, double z1, double x2, double y2, double z2, Direction dir) {
        VoxelShape[] rotated = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2), Direction.SOUTH));
        return rotated[dir.get2DDataValue()];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KitchenSinkBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof KitchenSinkBlockEntity)) {
            return InteractionResult.FAIL;
        }
        KitchenSinkBlockEntity sink = (KitchenSinkBlockEntity)be;
        if (stack.isEmpty()) {
            return this.fillFromNearbyFluid(sink, world, pos);
        }
        Item item = stack.getItem();
        if (item == Items.BUCKET) {
            return this.handleBucket(sink, player, hand, stack);
        }
        return this.fillFromItemStack(sink, player, hand, stack);
    }

    private InteractionResult fillFromNearbyFluid(KitchenSinkBlockEntity sink, Level world, BlockPos pos) {
        FluidState fs = world.getFluidState(pos.below(2));
        if (!fs.isSource() || fs.isEmpty()) {
            return InteractionResult.PASS;
        }
        Fluid fluid = fs.getType();
        if (!Config.isSinkUniversal() && fluid != Fluids.WATER) {
            return InteractionResult.FAIL;
        }
        return sink.addFluid(fluid) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private InteractionResult fillFromItemStack(KitchenSinkBlockEntity sink, Player player, InteractionHand hand, ItemStack stack) {
        Fluid fluid = FluidInteractionUtil.getFluidFromItemStack(stack);
        if (fluid == Fluids.EMPTY || stack.getItem() == Items.BUCKET) {
            return InteractionResult.FAIL;
        }
        if (!Config.isSinkUniversal() && fluid != Fluids.WATER) {
            return InteractionResult.FAIL;
        }
        boolean success = sink.addFluid(fluid);
        if (success && !player.isCreative()) {
            player.setItemInHand(hand, Items.BUCKET.getDefaultInstance());
        }
        return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private InteractionResult handleBucket(KitchenSinkBlockEntity sink, Player player, InteractionHand hand, ItemStack stack) {
        if (sink.isEmpty() || sink.getStoredAmount() < 1000) {
            return InteractionResult.FAIL;
        }
        Fluid fluid = sink.getFluid();
        Item filledBucket = fluid.getBucket();
        if (filledBucket == Items.AIR) {
            return InteractionResult.FAIL;
        }
        sink.removeFluid(1000);
        if (!player.isCreative()) {
            ItemStack newStack = filledBucket.getDefaultInstance();
            stack.shrink(1);
            if (stack.isEmpty()) {
                player.setItemInHand(hand, newStack);
            } else if (!player.getInventory().add(newStack)) {
                player.drop(newStack, false);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapesByState.get((Object)state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DIRECTION, WATERLOGGED, HAS_WATER});
    }
}

