/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public abstract class FluidContainerBlockEntity
extends BlockEntity {
    public static final int BUCKET_VOLUME = 1000;
    private Fluid fluid = Fluids.EMPTY;
    private int amount = 0;
    private final int capacity;

    public FluidContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int capacity) {
        super(type, pos, state);
        this.capacity = capacity;
    }

    public Fluid getFluid() {
        return this.fluid != null ? this.fluid : Fluids.EMPTY;
    }

    public int getStoredAmount() {
        return this.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        return this.fluid == Fluids.EMPTY || this.amount <= 0;
    }

    public void setFluidAndAmount(Fluid f, int a) {
        int clamped;
        if (f == null) {
            f = Fluids.EMPTY;
        }
        if ((clamped = Math.min(a, this.capacity)) <= 0) {
            this.fluid = Fluids.EMPTY;
            this.amount = 0;
        } else {
            this.fluid = f;
            this.amount = clamped;
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putString("FluidName", this.fluid == Fluids.EMPTY ? "minecraft:empty" : BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString());
        output.putInt("Amount", this.amount);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        String name = input.getString("FluidName").orElse("minecraft:empty");
        if ("minecraft:empty".equals(name)) {
            this.fluid = Fluids.EMPTY;
            this.amount = 0;
            return;
        }
        Fluid f = (Fluid)BuiltInRegistries.FLUID.getValue(ResourceLocation.tryParse((String)name));
        this.fluid = f != null ? f : Fluids.EMPTY;
        this.amount = Math.min(input.getInt("Amount").orElse(0), this.capacity);
        if (this.amount <= 0) {
            this.fluid = Fluids.EMPTY;
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

