/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.renderer.core.core_render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.tier1234.better_deco.block.entity.custom.FluidContainerBlockEntity;
import net.tier1234.better_deco.block.entity.renderer.core.core_render.FastColor;
import net.tier1234.better_deco.block.entity.renderer.core.core_render.FluidContainerRendererUtil;
import org.joml.Matrix4f;

public class FluidContainerRenderer {
    public static void drawContainer(Level world, BlockPos pos, FluidContainerBlockEntity be, AABB box, PoseStack ms, MultiBufferSource buf, int light) {
        Fluid fluid = be.getFluid();
        if (fluid == Fluids.EMPTY) {
            return;
        }
        FluidStack stack = new FluidStack(fluid, be.getStoredAmount());
        TextureAtlasSprite[] sprites = FluidContainerRendererUtil.getFluidSprites(fluid);
        if (sprites == null || sprites.length == 0 || sprites[0] == null) {
            return;
        }
        TextureAtlasSprite still = sprites[0];
        int color = FluidContainerRendererUtil.getFluidColor(stack, (BlockAndTintGetter)world, pos);
        if (fluid.isSame((Fluid)Fluids.WATER)) {
            color = BiomeColors.getAverageWaterColor((BlockAndTintGetter)world, (BlockPos)pos);
        }
        float r = (float)FastColor.ARGB32.red(color) / 255.0f;
        float g = (float)FastColor.ARGB32.green(color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue(color) / 255.0f;
        float a = 1.0f;
        float fullness = (float)be.getStoredAmount() / (float)be.getCapacity();
        float y = (float)box.minY + (float)(box.maxY - box.minY) * fullness;
        y = Math.min((float)box.maxY, Math.max((float)box.minY, y));
        float u0 = still.getU0() + (still.getU1() - still.getU0()) * (float)(box.minX - Math.floor(box.minX));
        float u1 = still.getU0() + (still.getU1() - still.getU0()) * (float)(box.maxX - Math.floor(box.minX));
        float v0 = still.getV0() + (still.getV1() - still.getV0()) * (float)(box.minZ - Math.floor(box.minZ));
        float v1 = still.getV0() + (still.getV1() - still.getV0()) * (float)(box.maxZ - Math.floor(box.minZ));
        VertexConsumer vc = buf.getBuffer(RenderType.translucentMovingBlock());
        Matrix4f mat = ms.last().pose();
        vc.addVertex(mat, (float)box.minX, y, (float)box.minZ).setColor(r, g, b, a).setUv(u0, v0).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(mat, (float)box.minX, y, (float)box.maxZ).setColor(r, g, b, a).setUv(u0, v1).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(mat, (float)box.maxX, y, (float)box.maxZ).setColor(r, g, b, a).setUv(u1, v1).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(mat, (float)box.maxX, y, (float)box.minZ).setColor(r, g, b, a).setUv(u1, v0).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
    }

    public static AABB createRotatedBox(Direction dir, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        minX /= 16.0;
        minY /= 16.0;
        minZ /= 16.0;
        maxX /= 16.0;
        maxY /= 17.0;
        maxZ /= 16.0;
        return switch (dir) {
            case Direction.WEST -> new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
            case Direction.NORTH -> new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
            case Direction.SOUTH -> new AABB(1.0 - minZ, minY, minX, 1.0 - maxZ, maxY, maxX);
            default -> new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        };
    }
}

