/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.renderer.core.core_render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class FluidContainerRendererUtil {
    public static TextureAtlasSprite[] getFluidSprites(Fluid fluid) {
        TextureAtlasSprite flowing;
        IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlas atlas = (TextureAtlas)Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS);
        TextureAtlasSprite still = ext.getStillTexture() != null ? atlas.getSprite(ext.getStillTexture()) : null;
        TextureAtlasSprite textureAtlasSprite = flowing = ext.getFlowingTexture() != null ? atlas.getSprite(ext.getFlowingTexture()) : null;
        if (still == null && flowing == null) {
            return null;
        }
        return new TextureAtlasSprite[]{still, flowing};
    }

    public static int getFluidColor(FluidStack stack, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        int color;
        FluidState state;
        IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
        FluidState fluidState = state = world != null && pos != null ? world.getFluidState(pos) : null;
        if (state == null || !state.is(stack.getFluid())) {
            state = stack.getFluid().defaultFluidState();
        }
        return (color = ext.getTintColor(state, world, pos)) != -1 ? color : -1;
    }
}

