/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tier1234.better_deco.recipe.MicrowaveRecipeInput;
import net.tier1234.better_deco.recipe.ModRecipes;

public record MicrowaveRecipe(Ingredient inputItem, ItemStack output) implements Recipe<MicrowaveRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.inputItem);
        return list;
    }

    public boolean matches(MicrowaveRecipeInput MicrowaveRecipeInput2, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.inputItem.test(MicrowaveRecipeInput2.getItem(0));
    }

    public ItemStack assemble(MicrowaveRecipeInput MicrowaveRecipeInput2, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<? extends Recipe<MicrowaveRecipeInput>> getSerializer() {
        return (RecipeSerializer)ModRecipes.MICROWAVE_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<MicrowaveRecipeInput>> getType() {
        return (RecipeType)ModRecipes.MICROWAVE_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create((Ingredient)this.inputItem);
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public static class Serializer
    implements RecipeSerializer<MicrowaveRecipe> {
        public static final MapCodec<MicrowaveRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(MicrowaveRecipe::inputItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(MicrowaveRecipe::output)).apply((Applicative)inst, MicrowaveRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MicrowaveRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, MicrowaveRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, MicrowaveRecipe::output, MicrowaveRecipe::new);

        public MapCodec<MicrowaveRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MicrowaveRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

