/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.client;

import appeng.api.client.AEKeyRenderHandler;
import appeng.client.gui.style.Blitter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.client.AppliedEClientConfig;
import gripe._90.appliede.me.key.EMCKey;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public final class EMCRenderer
implements AEKeyRenderHandler<EMCKey> {
    public static final EMCRenderer INSTANCE = new EMCRenderer();
    private final Supplier<TextureAtlasSprite> sprite = () -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(AppliedE.id("item/dummy_emc_item"));

    private EMCRenderer() {
    }

    public void drawInGui(Minecraft minecraft, GuiGraphics guiGraphics, int x, int y, EMCKey stack) {
        int hueIntervals = AppliedEClientConfig.CONFIG.getEmcTierColours();
        float hue = (float)(stack.getTier() - 1) * 360.0f / (float)hueIntervals / 360.0f;
        Blitter.sprite((TextureAtlasSprite)this.sprite.get()).blending(false).dest(x, y, 16, 16).colorRgb(Color.HSBtoRGB(hue, stack.getTier() == 1 ? 0.0f : 0.6f, 1.0f)).blit(guiGraphics);
    }

    public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, EMCKey what, float scale, int combinedLight, Level level) {
        TextureAtlasSprite s = this.sprite.get();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.01f);
        VertexConsumer buffer = buffers.getBuffer(RenderType.cutoutMipped());
        float x0 = -scale / 2.0f;
        float y0 = scale / 2.0f;
        float x1 = scale / 2.0f;
        float y1 = -scale / 2.0f;
        Matrix4f transform = poseStack.last().pose();
        buffer.addVertex(transform, x0, y1, 0.0f).setColor(-1).setUv(s.getU0(), s.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, x1, y1, 0.0f).setColor(-1).setUv(s.getU1(), s.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, x1, y0, 0.0f).setColor(-1).setUv(s.getU1(), s.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, x0, y0, 0.0f).setColor(-1).setUv(s.getU0(), s.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        poseStack.popPose();
    }

    public Component getDisplayName(EMCKey stack) {
        return stack.getDisplayName();
    }
}

