/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.client.screen;

import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.IconButton;
import appeng.core.localization.ButtonToolTips;
import appeng.menu.SlotSemantics;
import gripe._90.appliede.menu.EMCInterfaceMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EMCInterfaceScreen<M extends EMCInterfaceMenu>
extends UpgradeableScreen<M> {
    private final List<Button> amountButtons = new ArrayList<Button>();

    public EMCInterfaceScreen(M menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        List configSlots = menu.getSlots(SlotSemantics.CONFIG);
        for (int i = 0; i < configSlots.size(); ++i) {
            SetAmountButton button = new SetAmountButton(btn -> {
                int idx = this.amountButtons.indexOf(btn);
                Slot configSlot = (Slot)configSlots.get(idx);
                menu.openSetAmountMenu(configSlot.getSlotIndex());
            });
            button.setDisableBackground(true);
            button.setMessage((Component)ButtonToolTips.InterfaceSetStockAmount.text());
            this.widgets.add("amtButton" + (1 + i), (AbstractWidget)button);
            this.amountButtons.add((Button)button);
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        for (int i = 0; i < this.amountButtons.size(); ++i) {
            Button button = this.amountButtons.get(i);
            ItemStack item = ((Slot)((EMCInterfaceMenu)this.menu).getSlots(SlotSemantics.CONFIG).get(i)).getItem();
            button.visible = !item.isEmpty();
        }
    }

    private static class SetAmountButton
    extends IconButton {
        public SetAmountButton(Button.OnPress onPress) {
            super(onPress);
        }

        protected Icon getIcon() {
            return this.isHoveredOrFocused() ? Icon.COG : Icon.COG_DISABLED;
        }
    }
}

