/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.emc;

import appeng.core.definitions.AEBlocks;
import appeng.recipes.AERecipeTypes;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@RecipeTypeMapper
public class AE2RecipeTypeMapper
implements IRecipeTypeMapper {
    public boolean canHandle(RecipeType<?> recipeType) {
        return recipeType == AERecipeTypes.CHARGER || recipeType == AERecipeTypes.INSCRIBER || recipeType == AERecipeTypes.TRANSFORM;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> collector, RecipeHolder<?> holder, RegistryAccess access, INSSFakeGroupManager fakeGroupManager) {
        Recipe recipe = holder.value();
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)access);
        if (output.isEmpty()) {
            return false;
        }
        Collection<Ingredient> ingredients = AE2RecipeTypeMapper.getIngredients(recipe);
        if (ingredients.isEmpty()) {
            return true;
        }
        Object2IntOpenHashMap ingredientMap = new Object2IntOpenHashMap();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.hasNoItems()) continue;
            ItemStack[] items = ingredient.getItems();
            if (items.length == 1) {
                ingredientMap.mergeInt((Object)NSSItem.createItem((ItemStack)items[0]), 1, Integer::sum);
                continue;
            }
            Object2IntOpenHashMap rawNSSMatches = new Object2IntOpenHashMap(items.length);
            for (ItemStack item : items) {
                rawNSSMatches.put((Object)NSSItem.createItem((ItemStack)item), 1);
            }
            INSSFakeGroupManager.FakeGroupData fakeGroup = fakeGroupManager.getOrCreateFakeGroup((Object2IntMap)rawNSSMatches, true, true);
            NormalizedSimpleStack dummy = fakeGroup.dummy();
            ingredientMap.mergeInt((Object)dummy, 1, Integer::sum);
            if (!fakeGroup.created()) continue;
            for (ItemStack item : items) {
                Object2IntArrayMap groupIngredientMap = new Object2IntArrayMap(1);
                groupIngredientMap.put((Object)NSSItem.createItem((ItemStack)item), 1);
                collector.addConversion(1, (Object)dummy, (Object2IntMap)groupIngredientMap);
            }
        }
        collector.addConversion(output.getCount(), (Object)NSSItem.createItem((ItemStack)output), (Object2IntMap)ingredientMap);
        return true;
    }

    private static Collection<Ingredient> getIngredients(Recipe<?> recipe) {
        InscriberRecipe inscribe;
        if (recipe instanceof InscriberRecipe && (inscribe = (InscriberRecipe)recipe).getProcessType() == InscriberProcessType.INSCRIBE) {
            ItemStack output = inscribe.getResultItem();
            return inscribe.getTopOptional().test(output) || inscribe.getBottomOptional().test(output) ? Collections.emptyList() : Collections.singletonList(inscribe.getMiddleInput());
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.getIngredients());
        if (recipe instanceof TransformRecipe) {
            TransformRecipe transform = (TransformRecipe)recipe;
            if (transform.circumstance == TransformCircumstance.EXPLOSION) {
                ingredients.add(Ingredient.of((ItemLike[])new ItemLike[]{AEBlocks.TINY_TNT}));
            }
        }
        return ingredients;
    }

    public String getName() {
        return "AE2 Recipe Mapper";
    }

    public String getTranslationKey() {
        return "config.appliede.mapper.recipe";
    }

    public String getDescription() {
        return "(AppliedE) Maps recipes from Applied Energistics 2 such as for In-world Transformation, the Charger and the Inscriber.";
    }
}

