/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.emc;

import appeng.api.inventories.InternalInventory;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.items.contents.NetworkToolMenuHost;
import appeng.items.tools.NetworkToolItem;
import appeng.menu.locator.MenuLocators;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.components.DataComponentProcessor;
import moze_intel.projecte.api.components.IDataComponentProcessor;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@DataComponentProcessor
public class InventoryItemProcessor
implements IDataComponentProcessor {
    public String getTranslationKey() {
        return "config.appliede.mapper.inventory";
    }

    public String getName() {
        return "Inventory Item Processor";
    }

    public String getDescription() {
        return "(AppliedE) Calculates EMC value of Applied Energistics 2 inventory items such as cells and wireless terminals.";
    }

    public long recalculateEMC(@NotNull ItemInfo itemInfo, long currentEmc) throws ArithmeticException {
        ItemStack stack = itemInfo.createStack();
        if (stack.getItem() instanceof NetworkToolItem) {
            InternalInventory inventory = new NetworkToolMenuHost(null, null, MenuLocators.forStack((ItemStack)stack), null).getInventory();
            for (ItemStack item : inventory) {
                currentEmc = this.addEmc(currentEmc, item);
            }
            return currentEmc;
        }
        Item item = stack.getItem();
        if (!(item instanceof IUpgradeableItem)) {
            return currentEmc;
        }
        IUpgradeableItem upgradeable = (IUpgradeableItem)item;
        for (ItemStack upgrade : upgradeable.getUpgrades(stack)) {
            currentEmc = this.addEmc(currentEmc, upgrade);
        }
        StorageCell cell = StorageCells.getCellInventory((ItemStack)stack, null);
        if (cell != null && !cell.getAvailableStacks().isEmpty()) {
            return 0L;
        }
        return currentEmc;
    }

    private long addEmc(long currentEmc, ItemStack stack) throws ArithmeticException {
        long itemEmc = IEMCProxy.INSTANCE.getValue(stack);
        if (itemEmc > 0L) {
            long stackEmc = Math.multiplyExact(itemEmc, stack.getCount());
            currentEmc = Math.addExact(currentEmc, stackEmc);
        }
        return currentEmc;
    }
}

