/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.key;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import gripe._90.appliede.me.key.EMCKeyType;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class EMCKey
extends AEKey {
    static final MapCodec<EMCKey> MAP_CODEC = Codec.INT.fieldOf("tier").xmap(EMCKey::of, key -> key.tier);
    static final Codec<EMCKey> CODEC = MAP_CODEC.codec();
    public static final EMCKey BASE = new EMCKey(1);
    private final int tier;

    private EMCKey(int tier) {
        if (tier <= 0) {
            throw new IllegalArgumentException("Tier must be non-negative");
        }
        this.tier = tier;
    }

    public static EMCKey of(int tier) {
        return tier == 1 ? BASE : new EMCKey(tier);
    }

    public int getTier() {
        return this.tier;
    }

    public AEKeyType getType() {
        return EMCKeyType.TYPE;
    }

    public AEKey dropSecondary() {
        return this;
    }

    public CompoundTag toTag(HolderLookup.Provider registries) {
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return (CompoundTag)CODEC.encodeStart((DynamicOps)ops, (Object)this).getOrThrow();
    }

    public Object getPrimaryKey() {
        return this.tier;
    }

    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"projecte", (String)("emc_" + this.tier));
    }

    public void writeToPacket(RegistryFriendlyByteBuf data) {
        data.writeVarInt(this.tier);
    }

    protected Component computeDisplayName() {
        return Component.translatable((String)("key.appliede.emc" + (this.tier == 1 ? "" : "_tiered")), (Object[])new Object[]{this.tier});
    }

    public boolean hasComponents() {
        return true;
    }

    public void addDrops(long l, List<ItemStack> list, Level level, BlockPos blockPos) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof EMCKey)) return false;
        EMCKey key = (EMCKey)((Object)obj);
        if (this.tier != key.tier) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.tier);
    }
}

