/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.misc;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.me.storage.DelegatingMEInventory;
import appeng.util.ConfigInventory;
import appeng.util.Platform;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.block.EMCInterfaceBlock;
import gripe._90.appliede.me.misc.EMCInterfaceLogicHost;
import gripe._90.appliede.me.service.EMCStorage;
import gripe._90.appliede.me.service.KnowledgeService;
import java.util.List;
import java.util.Objects;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class EMCInterfaceLogic
implements IActionHost,
IGridTickable,
IUpgradeableObject {
    protected final EMCInterfaceLogicHost host;
    protected final IManagedGridNode mainNode;
    private final ConfigInventory config;
    private final ConfigInventory storage;
    private final IUpgradeInventory upgrades;
    private final MEStorage localInvHandler;
    private final GenericStack[] plannedWork;
    private final IActionSource source = IActionSource.ofMachine((IActionHost)this);
    @Nullable
    private WrappedEMCStorage emcStorage;
    private boolean hasConfig;

    public EMCInterfaceLogic(IManagedGridNode node, EMCInterfaceLogicHost host, Item is) {
        this(node, host, is, 9);
    }

    public EMCInterfaceLogic(IManagedGridNode node, EMCInterfaceLogicHost host, Item is, int slots) {
        this.host = host;
        this.mainNode = node.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).addService(IGridTickable.class, (IGridNodeService)this).setIdlePowerUsage(10.0);
        this.config = ConfigInventory.configStacks((int)slots).slotFilter(what -> AEItemKey.is((AEKey)what)).changeListener(this::onConfigRowChanged).build();
        this.storage = ConfigInventory.storage((int)slots).slotFilter(this::storageFilter).changeListener(this::onStorageChanged).build();
        this.upgrades = UpgradeInventories.forMachine((ItemLike)is, (int)1, host::saveChanges);
        this.localInvHandler = new DelegatingMEInventory((MEStorage)this.storage);
        this.plannedWork = new GenericStack[slots];
        this.config.useRegisteredCapacities();
        this.storage.useRegisteredCapacities();
    }

    public ConfigInventory getConfig() {
        return this.config;
    }

    public ConfigInventory getStorage() {
        return this.storage;
    }

    public MEStorage getInventory() {
        return this.hasConfig ? this.localInvHandler : this.emcStorage;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    private boolean storageFilter(AEKey what) {
        if (!(what instanceof AEItemKey)) {
            return false;
        }
        AEItemKey item = (AEItemKey)what;
        IGrid grid = this.mainNode.getGrid();
        IGridNode node = this.mainNode.getNode();
        if (grid == null || node == null) {
            return true;
        }
        KnowledgeService knowledge = (KnowledgeService)grid.getService(KnowledgeService.class);
        return knowledge.getKnownItems().contains(item) || this.isUpgradedWith((ItemLike)AppliedE.LEARNING_CARD) && IEMCProxy.INSTANCE.hasValue(item.toStack()) && knowledge.getProviderFor(node.getOwningPlayerProfileId()) != null;
    }

    public void readFromNBT(CompoundTag tag, HolderLookup.Provider registries) {
        this.config.readFromChildTag(tag, "config", registries);
        this.storage.readFromChildTag(tag, "storage", registries);
        this.upgrades.readFromNBT(tag, "upgrades", registries);
        this.readConfig();
    }

    public void writeToNBT(CompoundTag tag, HolderLookup.Provider registries) {
        this.config.writeToChildTag(tag, "config", registries);
        this.storage.writeToChildTag(tag, "storage", registries);
        this.upgrades.writeToNBT(tag, "upgrades", registries);
    }

    @Nullable
    public IGridNode getActionableNode() {
        return this.mainNode.getNode();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(5, 120, !this.hasWorkToDo());
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.mainNode.isActive()) {
            return TickRateModulation.SLEEP;
        }
        boolean couldDoWork = false;
        for (int i = 0; i < this.plannedWork.length; ++i) {
            GenericStack work = this.plannedWork[i];
            if (work == null) continue;
            boolean bl = couldDoWork = this.tryUsePlan(i, work.what(), (int)work.amount()) || couldDoWork;
            if (!couldDoWork) continue;
            this.updatePlan(i);
        }
        return this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
    }

    private boolean hasWorkToDo() {
        for (GenericStack requiredWork : this.plannedWork) {
            if (requiredWork == null) continue;
            return true;
        }
        return false;
    }

    private void updatePlan() {
        boolean hadWork = this.hasWorkToDo();
        for (int i = 0; i < this.config.size(); ++i) {
            this.updatePlan(i);
        }
        boolean hasWork = this.hasWorkToDo();
        if (hadWork != hasWork) {
            this.mainNode.ifPresent((grid, node) -> {
                if (hasWork) {
                    grid.getTickManager().alertDevice(node);
                } else {
                    grid.getTickManager().sleepDevice(node);
                }
            });
        }
    }

    private void updatePlan(int slot) {
        GenericStack req = this.config.getStack(slot);
        GenericStack stored = this.storage.getStack(slot);
        this.plannedWork[slot] = req == null && stored != null ? new GenericStack(stored.what(), -stored.amount()) : (req != null ? (stored == null ? req : (req.what().equals(stored.what()) ? (req.amount() != stored.amount() ? new GenericStack(req.what(), req.amount() - stored.amount()) : null) : new GenericStack(stored.what(), -stored.amount()))) : null);
    }

    private boolean tryUsePlan(int slot, AEKey what, int amount) {
        if (!(what instanceof AEItemKey)) {
            return false;
        }
        AEItemKey item = (AEItemKey)what;
        IGrid grid = this.mainNode.getGrid();
        if (grid == null) {
            return false;
        }
        if (amount < 0) {
            amount = -amount;
            GenericStack inSlot = this.storage.getStack(slot);
            if (!what.matches(inSlot) || inSlot.amount() < (long)amount) {
                return true;
            }
            long depositedItems = ((KnowledgeService)grid.getService(KnowledgeService.class)).getStorage().insertItem(item, amount, Actionable.MODULATE, this.source, this.isUpgradedWith((ItemLike)AppliedE.LEARNING_CARD));
            if (depositedItems > 0L) {
                this.storage.extract(slot, what, depositedItems, Actionable.MODULATE);
                return true;
            }
        }
        if (amount > 0) {
            return this.storage.insert(slot, what, (long)amount, Actionable.SIMULATE) != (long)amount || this.acquireFromNetwork(grid, slot, what, amount);
        }
        return false;
    }

    private boolean acquireFromNetwork(IGrid grid, int slot, AEKey what, long amount) {
        if (!(what instanceof AEItemKey)) {
            return false;
        }
        AEItemKey item = (AEItemKey)what;
        long acquiredItems = ((KnowledgeService)grid.getService(KnowledgeService.class)).getStorage().extractItem(item, amount, Actionable.MODULATE, this.source, true);
        if (acquiredItems > 0L) {
            long inserted = this.storage.insert(slot, what, acquiredItems, Actionable.MODULATE);
            if (inserted < acquiredItems) {
                throw new IllegalStateException("Bad attempt at managing inventory. Voided items: " + inserted);
            }
            return true;
        }
        return false;
    }

    private void readConfig() {
        this.hasConfig = !this.config.isEmpty();
        this.updatePlan();
        this.notifyNeighbours();
    }

    private void onConfigRowChanged() {
        this.host.saveChanges();
        this.readConfig();
    }

    private void onStorageChanged() {
        this.host.saveChanges();
        this.updatePlan();
    }

    public void notifyNeighbours() {
        this.mainNode.ifPresent((grid, node) -> {
            if (node.isActive()) {
                grid.getTickManager().wakeDevice(node);
            }
        });
        BlockEntity be = this.host.getBlockEntity();
        if (be != null && be.getLevel() != null) {
            Platform.notifyBlocksOfNeighbors((Level)be.getLevel(), (BlockPos)be.getBlockPos());
        }
    }

    public void gridChanged() {
        this.emcStorage = new WrappedEMCStorage(((KnowledgeService)Objects.requireNonNull(this.mainNode.getGrid()).getService(KnowledgeService.class)).getStorage());
        this.notifyNeighbours();
    }

    public void addDrops(List<ItemStack> drops) {
        for (int i = 0; i < this.storage.size(); ++i) {
            GenericStack stack = this.storage.getStack(i);
            if (stack == null) continue;
            BlockEntity be = this.host.getBlockEntity();
            stack.what().addDrops(stack.amount(), drops, be.getLevel(), be.getBlockPos());
        }
        for (ItemStack is : this.upgrades) {
            if (is.isEmpty()) continue;
            drops.add(is);
        }
    }

    public void clearContent() {
        this.storage.clear();
        this.upgrades.clear();
    }

    private class WrappedEMCStorage
    implements MEStorage {
        private final EMCStorage storage;

        private WrappedEMCStorage(EMCStorage storage) {
            this.storage = storage;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (!(what instanceof AEItemKey)) return 0L;
            AEItemKey item = (AEItemKey)what;
            if (!EMCInterfaceLogic.this.mainNode.isActive()) return 0L;
            long l = this.storage.insertItem(item, amount, mode, source, EMCInterfaceLogic.this.isUpgradedWith((ItemLike)AppliedE.LEARNING_CARD));
            return l;
        }

        public Component getDescription() {
            return ((EMCInterfaceBlock)((Object)AppliedE.EMC_INTERFACE.get())).getName();
        }
    }
}

