/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.misc;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.me.service.KnowledgeService;
import gripe._90.appliede.menu.TransmutationTerminalMenu;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class LearnAllItemsPacket
implements CustomPacketPayload {
    public static final LearnAllItemsPacket INSTANCE = new LearnAllItemsPacket();
    public static final CustomPacketPayload.Type<LearnAllItemsPacket> TYPE = new CustomPacketPayload.Type(AppliedE.id("learn_all"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LearnAllItemsPacket> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    private LearnAllItemsPacket() {
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player sender = context.player();
            AbstractContainerMenu patt0$temp = sender.containerMenu;
            if (!(patt0$temp instanceof TransmutationTerminalMenu)) {
                return;
            }
            TransmutationTerminalMenu menu = (TransmutationTerminalMenu)patt0$temp;
            IGridNode node = Objects.requireNonNull(menu.getHost().getActionableNode());
            IStorageService storage = node.getGrid().getStorageService();
            KnowledgeService knowledge = (KnowledgeService)node.getGrid().getService(KnowledgeService.class);
            if (knowledge.isTrackingPlayer(sender)) {
                for (AEKey key : storage.getCachedInventory().keySet()) {
                    if (!(key instanceof AEItemKey)) continue;
                    AEItemKey item = (AEItemKey)key;
                    if (knowledge.getProviderFor(sender.getUUID()).get().hasKnowledge(item.toStack())) continue;
                    long learned = knowledge.getStorage().insertItem(item, 1L, Actionable.MODULATE, IActionSource.ofPlayer((Player)sender), true, true, menu::showLearned);
                    MEStorage me = storage.getInventory();
                    me.extract((AEKey)item, learned, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)menu.getHost()));
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

