/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.service;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.AppliedEConfig;
import gripe._90.appliede.me.key.EMCKey;
import gripe._90.appliede.me.key.EMCKeyType;
import gripe._90.appliede.me.service.KnowledgeService;
import gripe._90.appliede.menu.TransmutationTerminalMenu;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class EMCStorage
implements MEStorage {
    private final KnowledgeService service;
    private int highestTier = 1;

    EMCStorage(KnowledgeService service) {
        this.service = service;
    }

    public void getAvailableStacks(KeyCounter out) {
        BigInteger emc = this.service.getEmc();
        int currentTier = 1;
        while (emc.divide(AppliedE.TIER_LIMIT).signum() == 1) {
            out.add((AEKey)EMCKey.of(currentTier), emc.remainder(AppliedE.TIER_LIMIT).longValue());
            emc = emc.divide(AppliedE.TIER_LIMIT);
            ++currentTier;
        }
        out.add((AEKey)EMCKey.of(currentTier), emc.longValue());
        if (this.highestTier != currentTier) {
            this.highestTier = currentTier;
            this.service.updatePatterns();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        EMCKey emc;
        block8: {
            block7: {
                if (amount <= 0L || !(what instanceof EMCKey)) break block7;
                emc = (EMCKey)what;
                if (!this.service.getProviders().isEmpty()) break block8;
            }
            return 0L;
        }
        if (mode == Actionable.MODULATE) {
            ArrayList<IKnowledgeProvider> providers = new ArrayList<IKnowledgeProvider>(this.service.getProviders());
            Collections.shuffle(providers);
            if (emc.getTier() == 1) {
                long quotient = amount / (long)providers.size();
                long remainder = amount % (long)providers.size();
                for (int p = 0; p < providers.size(); ++p) {
                    IKnowledgeProvider provider = providers.get(p);
                    provider.setEmc(provider.getEmc().add(BigInteger.valueOf(quotient + (long)((long)p < remainder ? 1 : 0))));
                }
            } else {
                BigInteger toInsert = BigInteger.valueOf(amount).multiply(AppliedE.TIER_LIMIT.pow(emc.getTier() - 1));
                EMCStorage.distributeEmc(toInsert, providers);
            }
            this.service.syncEmc();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount <= 0L || this.service.getProviders().isEmpty()) {
            return 0L;
        }
        if (what instanceof AEItemKey) {
            AEItemKey item = (AEItemKey)what;
            if (source.player().isPresent()) {
                return this.extractItem(item, amount, mode, source, false);
            }
        }
        if (!(what instanceof EMCKey)) {
            return 0L;
        }
        EMCKey emc = (EMCKey)what;
        BigInteger multiplier = AppliedE.TIER_LIMIT.pow(emc.getTier() - 1);
        BigInteger rawEmc = BigInteger.valueOf(amount).multiply(multiplier);
        BigInteger extracted = BigInteger.ZERO;
        List<IKnowledgeProvider> providers = this.getProvidersForExtraction(source);
        while (!providers.isEmpty() && extracted.compareTo(rawEmc) < 0) {
            Collections.shuffle(providers);
            BigInteger toExtract = rawEmc.subtract(extracted);
            BigInteger divisor = BigInteger.valueOf(providers.size());
            BigInteger quotient = toExtract.divide(divisor);
            long remainder = toExtract.remainder(divisor).longValue();
            for (int p = 0; p < providers.size(); ++p) {
                BigInteger toExtractFrom;
                IKnowledgeProvider provider = providers.get(p);
                BigInteger currentEmc = provider.getEmc();
                if (currentEmc.compareTo(toExtractFrom = quotient.add((long)p < remainder ? BigInteger.ONE : BigInteger.ZERO)) <= 0) {
                    if (mode == Actionable.MODULATE) {
                        provider.setEmc(BigInteger.ZERO);
                    }
                    extracted = extracted.add(currentEmc);
                    providers.remove(provider);
                    continue;
                }
                if (mode == Actionable.MODULATE) {
                    provider.setEmc(currentEmc.subtract(toExtractFrom));
                }
                extracted = extracted.add(toExtractFrom);
            }
        }
        if (mode == Actionable.MODULATE) {
            this.service.syncEmc();
        }
        return extracted.divide(multiplier).longValue();
    }

    public long insertItem(AEItemKey what, long amount, Actionable mode, IActionSource source, boolean mayLearn, boolean consumePower, Runnable onLearn) {
        Supplier<IKnowledgeProvider> machineProvider;
        if (amount <= 0L || this.service.getProviders().isEmpty()) {
            return 0L;
        }
        if (!mayLearn && !this.service.getKnownItems().contains(what) || !IEMCProxy.INSTANCE.hasValue(what.toStack())) {
            return 0L;
        }
        Player player = source.player().orElse(null);
        IActionHost machine = source.machine().orElse(null);
        Supplier<IKnowledgeProvider> playerProvider = player != null ? this.service.getProviderFor(player) : null;
        Supplier<IKnowledgeProvider> supplier = machineProvider = machine != null ? this.service.getProviderFor(machine) : null;
        if (mayLearn) {
            if (player != null && playerProvider == null) {
                return 0L;
            }
            if (machine != null && machineProvider == null) {
                return 0L;
            }
        }
        if (mode == Actionable.MODULATE) {
            BigInteger itemEmc = BigInteger.valueOf(IEMCProxy.INSTANCE.getSellValue(what.toStack()));
            BigInteger totalEmc = itemEmc.multiply(BigInteger.valueOf(amount));
            if (consumePower) {
                amount = EMCStorage.getAmountAfterPowerExpenditure(totalEmc, itemEmc, this.service.grid.getEnergyService());
            }
            if (amount == 0L) {
                return 0L;
            }
            ArrayList<IKnowledgeProvider> providers = new ArrayList<IKnowledgeProvider>(this.service.getProviders());
            Collections.shuffle(providers);
            EMCStorage.distributeEmc(totalEmc, providers);
            this.service.syncEmc();
            if (mayLearn) {
                if (player != null && !playerProvider.get().hasKnowledge(what.toStack())) {
                    EMCStorage.addKnowledge(what, playerProvider.get(), player);
                    onLearn.run();
                }
                if (machine != null && !machineProvider.get().hasKnowledge(what.toStack())) {
                    IGridNode node = Objects.requireNonNull(machine.getActionableNode());
                    ServerPlayer owner = IPlayerRegistry.getConnected((MinecraftServer)node.getLevel().getServer(), (int)node.getOwningPlayerId());
                    EMCStorage.addKnowledge(what, machineProvider.get(), (Player)owner);
                    onLearn.run();
                }
            }
        }
        return amount;
    }

    public long insertItem(AEItemKey what, long amount, Actionable mode, IActionSource source, boolean mayLearn) {
        return this.insertItem(what, amount, mode, source, mayLearn, true, () -> {});
    }

    public long extractItem(AEItemKey what, long amount, Actionable mode, IActionSource source, boolean skipStored) {
        List<IKnowledgeProvider> providers;
        if (source.player().isPresent() && !(((Player)source.player().get()).containerMenu instanceof TransmutationTerminalMenu)) {
            return 0L;
        }
        if (amount <= 0L || !this.service.getKnownItems().contains(what)) {
            return 0L;
        }
        KeyCounter existingStored = this.service.grid.getStorageService().getCachedInventory();
        if (!skipStored && existingStored.get((AEKey)what) > 0L) {
            return 0L;
        }
        BigInteger itemEmc = BigInteger.valueOf(IEMCProxy.INSTANCE.getValue(what.toStack()));
        if (itemEmc.signum() <= 0) {
            return 0L;
        }
        BigInteger totalEmc = itemEmc.multiply(BigInteger.valueOf(amount));
        BigInteger availableEmc = totalEmc.min((providers = this.getProvidersForExtraction(source)).equals(this.service.getProviders()) ? this.service.getEmc() : providers.getFirst().getEmc());
        if ((amount = availableEmc.divide(itemEmc).longValue()) == 0L) {
            return 0L;
        }
        if (mode == Actionable.MODULATE) {
            amount = EMCStorage.getAmountAfterPowerExpenditure(availableEmc, itemEmc, this.service.grid.getEnergyService());
            if (amount == 0L) {
                return 0L;
            }
            BigInteger withdrawn = BigInteger.ZERO;
            while (!providers.isEmpty() && withdrawn.compareTo(availableEmc) < 0) {
                Collections.shuffle(providers);
                BigInteger toWithdraw = availableEmc.subtract(withdrawn);
                BigInteger divisor = BigInteger.valueOf(providers.size());
                BigInteger quotient = toWithdraw.divide(divisor);
                long remainder = toWithdraw.remainder(divisor).longValue();
                for (int p = 0; p < providers.size(); ++p) {
                    BigInteger toWithdrawFrom;
                    IKnowledgeProvider provider = providers.get(p);
                    BigInteger currentEmc = provider.getEmc();
                    if (currentEmc.compareTo(toWithdrawFrom = quotient.add((long)p < remainder ? BigInteger.ONE : BigInteger.ZERO)) <= 0) {
                        provider.setEmc(BigInteger.ZERO);
                        withdrawn = withdrawn.add(currentEmc);
                        providers.remove(provider);
                        continue;
                    }
                    provider.setEmc(currentEmc.subtract(toWithdrawFrom));
                    withdrawn = withdrawn.add(toWithdrawFrom);
                }
            }
            this.service.syncEmc();
        }
        return amount;
    }

    private static void distributeEmc(BigInteger totalEmc, ArrayList<IKnowledgeProvider> providers) {
        BigInteger divisor = BigInteger.valueOf(providers.size());
        BigInteger quotient = totalEmc.divide(divisor);
        long remainder = totalEmc.remainder(divisor).longValue();
        for (int p = 0; p < providers.size(); ++p) {
            IKnowledgeProvider provider = providers.get(p);
            BigInteger added = quotient.add((long)p < remainder ? BigInteger.ONE : BigInteger.ZERO);
            provider.setEmc(provider.getEmc().add(added));
        }
    }

    private List<IKnowledgeProvider> getProvidersForExtraction(IActionSource source) {
        ArrayList<IKnowledgeProvider> providers = new ArrayList<IKnowledgeProvider>();
        if (source.player().isPresent() && AppliedEConfig.CONFIG.terminalExtractFromOwnEmcOnly()) {
            Supplier<IKnowledgeProvider> provider = this.service.getProviderFor((Player)source.player().get());
            providers.add(provider.get());
        } else {
            providers.addAll(this.service.getProviders());
        }
        return providers;
    }

    private static long getAmountAfterPowerExpenditure(BigInteger maxEmc, BigInteger itemEmc, IEnergyService energy) {
        BigDecimal multiplier = BigDecimal.valueOf(PowerMultiplier.CONFIG.multiplier).multiply(BigDecimal.valueOf(AppliedEConfig.CONFIG.getTransmutationPowerMultiplier())).divide(BigDecimal.valueOf(EMCKeyType.TYPE.getAmountPerOperation()), 4, RoundingMode.HALF_UP);
        BigDecimal toExpend = new BigDecimal(maxEmc).multiply(multiplier).min(BigDecimal.valueOf(Double.MAX_VALUE));
        double available = energy.extractAEPower(toExpend.doubleValue(), Actionable.SIMULATE, PowerMultiplier.ONE);
        double expended = Math.min(available, toExpend.doubleValue());
        long amount = BigDecimal.valueOf(available).min(toExpend).divide(multiplier, RoundingMode.HALF_UP).toBigInteger().divide(itemEmc).longValue();
        if (amount > 0L) {
            energy.extractAEPower(expended, Actionable.MODULATE, PowerMultiplier.ONE);
        }
        return amount;
    }

    private static void addKnowledge(AEItemKey what, IKnowledgeProvider provider, Player player) {
        ItemStack stack = what.toStack();
        provider.addKnowledge(stack);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            provider.syncKnowledgeChange(serverPlayer, ItemInfo.fromStack((ItemStack)stack), true);
        }
    }

    int getHighestTier() {
        return this.highestTier;
    }

    public Component getDescription() {
        return ((Item)AppliedE.EMC_MODULE.get()).getDescription();
    }
}

