/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.service;

import appeng.api.features.IPlayerRegistry;
import cn.leomc.teamprojecte.TPTeam;
import cn.leomc.teamprojecte.TeamChangeEvent;
import gripe._90.appliede.me.service.KnowledgeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

final class TeamProjectEHandler {
    private final Map<TPTeam, Supplier<IKnowledgeProvider>> providersPerTeam = new HashMap<TPTeam, Supplier<IKnowledgeProvider>>();

    private TeamProjectEHandler() {
        NeoForge.EVENT_BUS.addListener(ServerStoppedEvent.class, event -> this.clear());
        NeoForge.EVENT_BUS.addListener(TeamChangeEvent.class, event -> this.clear());
    }

    private boolean notSharingEmc(Map.Entry<UUID, Supplier<IKnowledgeProvider>> entry) {
        TPTeam team = TPTeam.getOrCreateTeam((UUID)entry.getKey());
        Supplier<IKnowledgeProvider> provider = entry.getValue();
        return !team.isSharingEMC() || this.providersPerTeam.containsValue(provider) || this.providersPerTeam.putIfAbsent(team, provider) == null;
    }

    private boolean isPlayerInTrackedTeam(UUID uuid) {
        for (TPTeam team : this.providersPerTeam.keySet()) {
            if (!team.getMembers().contains(uuid)) continue;
            return true;
        }
        return false;
    }

    private Supplier<IKnowledgeProvider> getProviderFor(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Map.Entry<TPTeam, Supplier<IKnowledgeProvider>> entry : this.providersPerTeam.entrySet()) {
            if (!entry.getKey().getMembers().contains(uuid)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void syncTeamProviders() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (TPTeam team : this.providersPerTeam.keySet()) {
                ArrayList<UUID> members = new ArrayList<UUID>(team.getMembers());
                members.add(team.getOwner());
                for (UUID member : members) {
                    int id = IPlayerRegistry.getMapping((MinecraftServer)server).getPlayerId(member);
                    ServerPlayer player = IPlayerRegistry.getConnected((MinecraftServer)server, (int)id);
                    if (player == null) continue;
                    KnowledgeService.retrieveProvider(member).get().syncEmc(player);
                }
            }
        }
    }

    private void clear() {
        this.providersPerTeam.clear();
    }

    static class Proxy {
        private final Object handler = ModList.get().isLoaded("teamprojecte") ? new TeamProjectEHandler() : null;

        Proxy() {
        }

        boolean notSharingEmc(Map.Entry<UUID, Supplier<IKnowledgeProvider>> provider) {
            return this.handler == null || ((TeamProjectEHandler)this.handler).notSharingEmc(provider);
        }

        boolean isPlayerInTrackedTeam(UUID uuid) {
            return this.handler == null || ((TeamProjectEHandler)this.handler).isPlayerInTrackedTeam(uuid);
        }

        Supplier<IKnowledgeProvider> getProviderFor(UUID uuid) {
            return this.handler != null ? ((TeamProjectEHandler)this.handler).getProviderFor(uuid) : null;
        }

        void syncTeamProviders(Map<UUID, Supplier<IKnowledgeProvider>> fallbackProviders) {
            if (this.handler != null) {
                ((TeamProjectEHandler)this.handler).syncTeamProviders();
            } else {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    fallbackProviders.forEach((uuid, provider) -> {
                        int id = IPlayerRegistry.getMapping((MinecraftServer)server).getPlayerId(uuid);
                        ServerPlayer player = IPlayerRegistry.getConnected((MinecraftServer)server, (int)id);
                        if (player != null) {
                            ((IKnowledgeProvider)provider.get()).syncEmc(player);
                        }
                    });
                }
            }
        }

        void clear() {
            if (this.handler != null) {
                ((TeamProjectEHandler)this.handler).clear();
            }
        }
    }
}

