/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.service;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.me.key.EMCKey;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class TransmutationPattern
implements IPatternDetails {
    private final Item output;
    private final long amount;
    private final int tier;
    private final int job;
    private final AEItemKey definition;

    public TransmutationPattern(Item output, long amount, int job) {
        this.tier = 1;
        ItemStack definition = AppliedE.DUMMY_EMC_ITEM.toStack();
        this.output = output;
        this.amount = amount;
        this.job = job;
        definition.set(AppliedE.ENCODED_TRANSMUTATION_PATTERN.get(), (Object)new Encoded(this.output, this.amount, this.tier, this.job));
        this.definition = AEItemKey.of((ItemStack)definition);
    }

    public TransmutationPattern(int tier) {
        this.output = Items.AIR;
        this.amount = 1L;
        this.job = 0;
        ItemStack definition = AppliedE.DUMMY_EMC_ITEM.toStack();
        this.tier = tier;
        definition.set(AppliedE.ENCODED_TRANSMUTATION_PATTERN.get(), (Object)new Encoded(this.output, this.amount, this.tier, this.job));
        this.definition = AEItemKey.of((ItemStack)definition);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        if (this.output == Items.AIR) {
            return new IPatternDetails.IInput[]{new Input(1L, this.tier)};
        }
        ArrayList<Input> inputs = new ArrayList<Input>();
        long itemEmc = IEMCProxy.INSTANCE.getValue((ItemLike)this.output);
        BigInteger totalEmc = BigInteger.valueOf(itemEmc).multiply(BigInteger.valueOf(this.amount));
        int currentTier = 1;
        while (totalEmc.divide(AppliedE.TIER_LIMIT).signum() == 1) {
            inputs.add(new Input(totalEmc.remainder(AppliedE.TIER_LIMIT).longValue(), currentTier));
            totalEmc = totalEmc.divide(AppliedE.TIER_LIMIT);
            ++currentTier;
        }
        inputs.add(new Input(totalEmc.longValue(), currentTier));
        return inputs.toArray(new IPatternDetails.IInput[0]);
    }

    public List<GenericStack> getOutputs() {
        return Collections.singletonList(this.output != Items.AIR ? new GenericStack((AEKey)AEItemKey.of((ItemLike)this.output), this.amount) : new GenericStack((AEKey)EMCKey.of(this.tier - 1), AppliedE.TIER_LIMIT.longValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TransmutationPattern)) return false;
        TransmutationPattern pattern = (TransmutationPattern)obj;
        if (!pattern.output.equals(this.output)) return false;
        if (pattern.amount != this.amount) return false;
        if (pattern.tier != this.tier) return false;
        if (pattern.job != this.job) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.output, this.amount, this.tier, this.job);
    }

    public record Encoded(Item output, long amount, int tier, int job) {
        public static final Codec<Encoded> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("output").forGetter(Encoded::output), (App)Codec.LONG.fieldOf("amount").forGetter(Encoded::amount), (App)Codec.INT.fieldOf("tier").forGetter(Encoded::tier), (App)Codec.INT.fieldOf("job").forGetter(Encoded::job)).apply((Applicative)builder, Encoded::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Encoded> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), Encoded::output, (StreamCodec)ByteBufCodecs.VAR_LONG, Encoded::amount, (StreamCodec)ByteBufCodecs.VAR_INT, Encoded::tier, (StreamCodec)ByteBufCodecs.VAR_INT, Encoded::job, Encoded::new);
    }

    private record Input(long amount, int tier) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)EMCKey.of(this.tier), this.amount)};
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

