/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.menu;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.slot.InaccessibleSlot;
import appeng.util.inv.AppEngInternalInventory;
import com.google.common.primitives.Ints;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.me.misc.EMCInterfaceLogicHost;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EMCSetStockAmountMenu
extends AEBaseMenu
implements ISubMenu {
    private final EMCInterfaceLogicHost host;
    private final Slot stockedItem;
    private AEItemKey whatToStock;
    @GuiSync(value=1)
    private int initialAmount = -1;
    @GuiSync(value=2)
    private int maxAmount = -1;
    private int slot;

    public EMCSetStockAmountMenu(int id, Inventory playerInventory, EMCInterfaceLogicHost host) {
        super(AppliedE.EMC_SET_STOCK_AMOUNT_MENU.get(), id, playerInventory, (Object)host);
        this.registerClientAction("setStockAmount", Integer.class, this::confirm);
        this.host = host;
        this.stockedItem = new InaccessibleSlot((InternalInventory)new AppEngInternalInventory(1), 0);
        this.addSlot(this.stockedItem, SlotSemantics.MACHINE_OUTPUT);
    }

    public EMCInterfaceLogicHost getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuHostLocator locator, int slot, AEItemKey toStock, int initialAmount) {
        MenuOpener.open(AppliedE.EMC_SET_STOCK_AMOUNT_MENU.get(), (Player)player, (MenuHostLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof EMCSetStockAmountMenu) {
            EMCSetStockAmountMenu stockMenu = (EMCSetStockAmountMenu)abstractContainerMenu;
            stockMenu.setWhatToStock(slot, toStock, initialAmount);
            stockMenu.broadcastChanges();
        }
    }

    private void setWhatToStock(int slot, AEItemKey whatToStock, int initialAmount) {
        this.slot = slot;
        this.whatToStock = Objects.requireNonNull(whatToStock, "whatToStock");
        this.initialAmount = initialAmount;
        this.maxAmount = Ints.saturatedCast((long)this.host.getConfig().getMaxAmount((AEKey)whatToStock));
        this.stockedItem.set(whatToStock.wrapForDisplayOrFilter());
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public void confirm(int amount) {
        if (this.isClientSide()) {
            this.sendClientAction("setStockAmount", amount);
            return;
        }
        GenericStackInv config = this.host.getConfig();
        if (!Objects.equals(config.getKey(this.slot), this.whatToStock)) {
            this.host.returnToMainMenu(this.getPlayer(), this);
            return;
        }
        config.setStack(this.slot, (amount = (int)Math.min((long)amount, config.getMaxAmount((AEKey)this.whatToStock))) <= 0 ? null : new GenericStack((AEKey)this.whatToStock, (long)amount));
        this.host.returnToMainMenu(this.getPlayer(), this);
    }

    public int getInitialAmount() {
        return this.initialAmount;
    }

    @Nullable
    public AEItemKey getWhatToStock() {
        AEItemKey item;
        AEKey aEKey;
        GenericStack stack = GenericStack.fromItemStack((ItemStack)this.stockedItem.getItem());
        return stack != null && (aEKey = stack.what()) instanceof AEItemKey ? (item = (AEItemKey)aEKey) : null;
    }
}

