/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.menu;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.ITerminalHost;
import appeng.helpers.InventoryAction;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.slot.FakeSlot;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.me.misc.TransmutationTerminalHost;
import gripe._90.appliede.me.service.KnowledgeService;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TransmutationTerminalMenu
extends MEStorageMenu {
    protected static final SlotSemantic TRANSMUTE = SlotSemantics.register((String)"APPLIEDE_TRANSMUTE", (boolean)false);
    protected static final SlotSemantic UNLEARN = SlotSemantics.register((String)"APPLIEDE_UNLEARN", (boolean)false);
    private static final String ACTION_SET_SHIFT = "setShiftDestination";
    private static final String ACTION_HIDE_LEARNED = "hideLearnedText";
    private static final String ACTION_HIDE_UNLEARNED = "hideUnlearnedText";
    private final TransmutationTerminalHost host;
    private final Slot transmuteSlot = new FakeSlot(InternalInventory.empty(), 0);
    private final Slot unlearnSlot = new FakeSlot(InternalInventory.empty(), 0);
    @GuiSync(value=1)
    public boolean shiftToTransmute;
    @GuiSync(value=2)
    public int learnedLabelTicks;
    @GuiSync(value=3)
    public int unlearnedLabelTicks;

    public TransmutationTerminalMenu(int id, Inventory ip, TransmutationTerminalHost host) {
        this(AppliedE.TRANSMUTATION_TERMINAL_MENU.get(), id, ip, host, true);
    }

    public TransmutationTerminalMenu(MenuType<?> menuType, int id, Inventory ip, TransmutationTerminalHost host, boolean bindInventory) {
        super(menuType, id, ip, (ITerminalHost)host, bindInventory);
        this.host = host;
        this.registerClientAction(ACTION_SET_SHIFT, Boolean.class, host::setShiftToTransmute);
        this.registerClientAction(ACTION_HIDE_LEARNED, () -> --this.learnedLabelTicks);
        this.registerClientAction(ACTION_HIDE_UNLEARNED, () -> --this.unlearnedLabelTicks);
        this.addSlot(this.transmuteSlot, TRANSMUTE);
        this.addSlot(this.unlearnSlot, UNLEARN);
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        IKnowledgeProvider provider;
        KnowledgeService knowledge;
        IGridNode node;
        super.doAction(player, action, slot, id);
        Slot s = this.getSlot(slot);
        if (s.equals(this.transmuteSlot) && !this.getCarried().isEmpty()) {
            int transmuted = this.transmuteItem(this.getCarried(), action == InventoryAction.SPLIT_OR_PLACE_SINGLE, (Player)player);
            ItemStack reduced = this.getCarried().copy();
            reduced.setCount(reduced.getCount() - transmuted);
            this.setCarried(reduced.getCount() <= 0 ? ItemStack.EMPTY : reduced);
        }
        if (s.equals(this.unlearnSlot) && !this.getCarried().isEmpty() && (node = this.host.getActionableNode()) != null && (knowledge = (KnowledgeService)node.getGrid().getService(KnowledgeService.class)).isTrackingPlayer((Player)player) && (provider = knowledge.getProviderFor(player.getUUID()).get()).hasKnowledge(this.getCarried())) {
            provider.removeKnowledge(this.getCarried());
            provider.syncKnowledgeChange(player, ItemInfo.fromStack((ItemStack)this.getCarried()), false);
            this.unlearnedLabelTicks = 300;
            this.learnedLabelTicks = 0;
            this.broadcastChanges();
        }
    }

    private int transmuteItem(ItemStack stack, boolean singleItem, Player player) {
        if (!stack.isEmpty()) {
            IGridNode node = this.host.getActionableNode();
            if (node == null) {
                return 0;
            }
            KnowledgeService knowledge = (KnowledgeService)node.getGrid().getService(KnowledgeService.class);
            if (!knowledge.isTrackingPlayer(player)) {
                return 0;
            }
            return (int)knowledge.getStorage().insertItem(AEItemKey.of((ItemStack)stack), singleItem ? 1L : (long)stack.getCount(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player), true, true, this::showLearned);
        }
        return 0;
    }

    public void setShiftToTransmute(boolean transmute) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_SHIFT, transmute);
            return;
        }
        this.shiftToTransmute = transmute;
    }

    public void showLearned() {
        this.learnedLabelTicks = 300;
        this.unlearnedLabelTicks = 0;
        this.broadcastChanges();
    }

    public void decrementLearnedTicks() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_HIDE_LEARNED);
        }
    }

    public void decrementUnlearnedTicks() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_HIDE_UNLEARNED);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int idx) {
        if (this.shiftToTransmute) {
            ItemStack stack = ((Slot)this.slots.get(idx)).getItem();
            ItemStack remaining = stack.copy();
            remaining.setCount(remaining.getCount() - this.transmuteItem(stack, false, player));
            ((Slot)this.slots.get(idx)).set(remaining.getCount() <= 0 ? ItemStack.EMPTY : remaining);
            return ItemStack.EMPTY;
        }
        return super.quickMoveStack(player, idx);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.isServerSide()) {
            this.shiftToTransmute = this.host.getShiftToTransmute();
        }
    }

    public TransmutationTerminalHost getHost() {
        return this.host;
    }
}

