/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.part;

import appeng.api.config.Actionable;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.IConfigManagerBuilder;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.automation.IOBusPart;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.me.key.EMCKey;
import gripe._90.appliede.me.key.EMCKeyType;
import gripe._90.appliede.me.service.EMCStorage;
import gripe._90.appliede.me.service.KnowledgeService;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMCExportBusPart
extends IOBusPart {
    private static final ResourceLocation MODEL_BASE = AppliedE.id("part/emc_export_bus");
    @PartModels
    private static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_off")});
    @PartModels
    private static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_on")});
    @PartModels
    private static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_has_channel")});
    private static final Logger LOGGER = LoggerFactory.getLogger(EMCExportBusPart.class);
    private BlockCapabilityCache<IItemHandler, Direction> itemCache;
    private BlockCapabilityCache<IEmcStorage, Direction> emcCache;
    private int nextSlot = 0;

    public EMCExportBusPart(IPartItem<?> partItem) {
        super(TickRates.ExportBus, Set.of(AEKeyType.items(), EMCKeyType.TYPE), partItem);
    }

    public void readFromNBT(CompoundTag extra, HolderLookup.Provider registries) {
        super.readFromNBT(extra, registries);
        this.nextSlot = extra.getInt("nextSlot");
    }

    public void writeToNBT(CompoundTag extra, HolderLookup.Provider registries) {
        super.writeToNBT(extra, registries);
        extra.putInt("nextSlot", this.nextSlot);
    }

    protected void registerSettings(IConfigManagerBuilder builder) {
        super.registerSettings(builder);
        builder.registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
    }

    protected boolean doBusWork(IGrid grid) {
        if (this.itemCache == null || this.emcCache == null) {
            BlockPos adjacentPos = this.getHost().getBlockEntity().getBlockPos().relative(this.getSide());
            Direction facing = this.getSide().getOpposite();
            ServerLevel level = (ServerLevel)this.getLevel();
            this.itemCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)level, (BlockPos)adjacentPos, (Object)facing);
            this.emcCache = BlockCapabilityCache.create((BlockCapability)PECapabilities.EMC_STORAGE_CAPABILITY, (ServerLevel)level, (BlockPos)adjacentPos, (Object)facing);
        }
        boolean doneWork = false;
        EMCStorage networkEmc = ((KnowledgeService)grid.getService(KnowledgeService.class)).getStorage();
        SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
        AtomicInteger remaining = new AtomicInteger(this.getOperationsPerTick());
        int slot = 0;
        for (slot = 0; slot < this.availableSlots() && remaining.get() > 0; ++slot) {
            ItemStack remainder;
            Object object;
            int startingSlot = switch (schedulingMode) {
                case SchedulingMode.RANDOM -> this.getLevel().getRandom().nextInt(this.availableSlots());
                case SchedulingMode.ROUNDROBIN -> (this.nextSlot + slot) % this.availableSlots();
                default -> slot;
            };
            AEKey what = this.getConfig().getKey(startingSlot);
            if (what == EMCKey.BASE && (object = this.emcCache.getCapability()) instanceof IEmcStorage) {
                IEmcStorage handler = (IEmcStorage)object;
                int rem = remaining.get() * EMCKeyType.TYPE.getAmountPerOperation();
                long insertable = handler.insertEmc((long)rem, IEmcStorage.EmcAction.SIMULATE);
                long extracted = StorageHelper.poweredExtraction((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)EMCKey.BASE, (long)insertable, (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                if (extracted <= 0L) continue;
                handler.insertEmc(extracted, IEmcStorage.EmcAction.EXECUTE);
                remaining.addAndGet((int)(-Math.max(1L, extracted / (long)EMCKeyType.TYPE.getAmountPerOperation())));
                continue;
            }
            if (!(what instanceof AEItemKey)) continue;
            AEItemKey item = (AEItemKey)what;
            Object rem = this.itemCache.getCapability();
            if (!(rem instanceof IItemHandler)) continue;
            IItemHandler handler = (IItemHandler)rem;
            int rem2 = remaining.get();
            ItemStack stack = item.toStack(rem2);
            long extracted = networkEmc.extractItem(item, rem2, Actionable.SIMULATE, this.source, true);
            long wasInserted = extracted - (long)(remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true)).getCount();
            if (wasInserted > 0L && (wasInserted = (extracted = networkEmc.extractItem(item, rem2, Actionable.MODULATE, this.source, true)) - (long)(remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false)).getCount()) < extracted) {
                long leftover = extracted - wasInserted;
                if ((leftover -= networkEmc.insertItem(item, leftover, Actionable.MODULATE, this.source, false, false, () -> {})) > 0L) {
                    LOGGER.error("Storage export: adjacent block unexpectedly refused insert, voided {}x{}", (Object)leftover, (Object)item);
                }
            }
            if (wasInserted <= 0L) continue;
            remaining.addAndGet(-((int)wasInserted));
        }
        if (remaining.get() < this.getOperationsPerTick()) {
            if (schedulingMode == SchedulingMode.ROUNDROBIN) {
                this.nextSlot = (this.nextSlot + slot) % this.availableSlots();
            }
            doneWork = true;
        }
        return doneWork;
    }

    protected MenuType<?> getMenuType() {
        return AppliedE.EMC_EXPORT_BUS_MENU.get();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    public IPartModel getStaticModels() {
        return this.isActive() ? MODELS_HAS_CHANNEL : (this.isPowered() ? MODELS_ON : MODELS_OFF);
    }
}

