/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.part;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.storage.ExternalStorageFacade;
import appeng.parts.PartModel;
import appeng.parts.automation.IOBusPart;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.me.key.EMCKey;
import gripe._90.appliede.me.key.EMCKeyType;
import gripe._90.appliede.me.service.EMCStorage;
import gripe._90.appliede.me.service.KnowledgeService;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class EMCImportBusPart
extends IOBusPart {
    private static final ResourceLocation MODEL_BASE = AppliedE.id("part/emc_import_bus");
    @PartModels
    private static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/import_bus_off")});
    @PartModels
    private static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/import_bus_on")});
    @PartModels
    private static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/import_bus_has_channel")});
    private BlockCapabilityCache<IItemHandler, Direction> itemCache;
    private BlockCapabilityCache<IEmcStorage, Direction> emcCache;

    public EMCImportBusPart(IPartItem<?> partItem) {
        super(TickRates.ImportBus, Set.of(AEKeyType.items(), EMCKeyType.TYPE), partItem);
    }

    protected MenuType<?> getMenuType() {
        return AppliedE.EMC_IMPORT_BUS_MENU.get();
    }

    protected boolean doBusWork(IGrid grid) {
        Object emcRemaining2;
        IEmcStorage handler;
        if (this.itemCache == null || this.emcCache == null) {
            BlockPos adjacentPos = this.getHost().getBlockEntity().getBlockPos().relative(this.getSide());
            Direction facing = this.getSide().getOpposite();
            ServerLevel level = (ServerLevel)this.getLevel();
            this.itemCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)level, (BlockPos)adjacentPos, (Object)facing);
            this.emcCache = BlockCapabilityCache.create((BlockCapability)PECapabilities.EMC_STORAGE_CAPABILITY, (ServerLevel)level, (BlockPos)adjacentPos, (Object)facing);
        }
        boolean doneWork = false;
        EMCStorage networkEmc = ((KnowledgeService)grid.getService(KnowledgeService.class)).getStorage();
        AtomicInteger remaining = new AtomicInteger(this.getOperationsPerTick());
        Object object = this.emcCache.getCapability();
        if (object instanceof IEmcStorage) {
            handler = (IEmcStorage)object;
            if (this.getFilter().isEmpty() || this.getFilter().isListed((AEKey)EMCKey.BASE) != this.isUpgradedWith((ItemLike)AEItems.INVERTER_CARD)) {
                int emcRemaining2 = remaining.get() * EMCKeyType.TYPE.getAmountPerOperation();
                long inserted = StorageHelper.poweredInsert((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)EMCKey.BASE, (long)Math.min((long)emcRemaining2, handler.getStoredEmc()), (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                handler.extractEmc(inserted, IEmcStorage.EmcAction.EXECUTE);
                remaining.addAndGet((int)(-Math.max(1L, inserted / (long)EMCKeyType.TYPE.getAmountPerOperation())));
            }
        }
        if ((emcRemaining2 = this.itemCache.getCapability()) instanceof IItemHandler) {
            handler = (IItemHandler)emcRemaining2;
            ExternalStorageFacade adjacentStorage = ExternalStorageFacade.of((IItemHandler)handler);
            for (int slot = 0; slot < handler.getSlots() && remaining.get() > 0; ++slot) {
                long amount;
                AEItemKey item = AEItemKey.of((ItemStack)handler.getStackInSlot(slot));
                if (item == null || !this.getFilter().isEmpty() && this.getFilter().isListed((AEKey)item) == this.isUpgradedWith((ItemLike)AEItems.INVERTER_CARD) || (amount = adjacentStorage.extract((AEKey)item, (long)remaining.get(), Actionable.SIMULATE, this.source)) <= 0L) continue;
                boolean mayLearn = this.isUpgradedWith((ItemLike)AppliedE.LEARNING_CARD);
                amount = networkEmc.insertItem(item, amount, Actionable.MODULATE, this.source, mayLearn);
                adjacentStorage.extract((AEKey)item, amount, Actionable.MODULATE, this.source);
                remaining.addAndGet(-((int)amount));
            }
        }
        if (remaining.get() < this.getOperationsPerTick()) {
            doneWork = true;
        }
        return doneWork;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    public IPartModel getStaticModels() {
        return this.isActive() ? MODELS_HAS_CHANNEL : (this.isPowered() ? MODELS_ON : MODELS_OFF);
    }
}

