/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public class ResourceScanner {
    public static Map<ResourceLocation, JsonElement> scanDirectory(ResourceManager pResourceManager, String pName, Gson pGson) {
        return ResourceScanner.scanDirectory(pResourceManager, FileToIdConverter.m_246568_((String)pName), pGson);
    }

    public static Map<ResourceLocation, JsonElement> scanDirectory(ResourceManager pResourceManager, FileToIdConverter filetoidconverter, Gson pGson) {
        HashMap output = Maps.newHashMap();
        for (Map.Entry entry : filetoidconverter.m_247457_(pResourceManager).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourcelocation1 = filetoidconverter.m_245273_(resourcelocation);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonElement jsonelement = (JsonElement)GsonHelper.m_263475_((Gson)pGson, (Reader)reader, JsonElement.class, (boolean)true);
                    JsonElement jsonelement1 = output.put(resourcelocation1, jsonelement);
                    if (jsonelement1 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourcelocation1));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                GunMod.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        return output;
    }

    public static Map<ResourceLocation, List<JsonElement>> scanDirectoryAll(ResourceManager pResourceManager, FileToIdConverter filetoidconverter, Gson pGson) {
        HashMap output = Maps.newHashMap();
        for (Map.Entry entry : filetoidconverter.m_246760_(pResourceManager).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourcelocation1 = filetoidconverter.m_245273_(resourcelocation);
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement jsonelement = (JsonElement)GsonHelper.m_263475_((Gson)pGson, (Reader)reader, JsonElement.class, (boolean)true);
                        List list = output.computeIfAbsent(resourcelocation1, k -> Lists.newArrayList());
                        list.add(jsonelement);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                    GunMod.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)jsonparseexception);
                }
            }
        }
        return output;
    }
}

