/*
 * Decompiled with CFR 0.152.
 */
package main.locator;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Locator
implements ModInitializer {
    private static final Map<String, Integer> BASE_COST = Map.of("structure", 5, "biome", 3, "poi", 2);
    private static final Map<String, Integer> STRUCTURE_COSTS = Map.ofEntries(Map.entry("ancient_city", 10), Map.entry("bastion_remnant", 8), Map.entry("buried_treasure", 6), Map.entry("end_city", 10), Map.entry("fortress", 8), Map.entry("mansion", 9), Map.entry("monument", 8), Map.entry("pillager_outpost", 4), Map.entry("ruined_portal", 3), Map.entry("shipwreck", 4), Map.entry("stronghold", 10), Map.entry("village", 3), Map.entry("woodland_mansion", 9), Map.entry("desert_pyramid", 5), Map.entry("igloo", 4), Map.entry("jungle_pyramid", 5), Map.entry("nether_fossil", 4), Map.entry("ocean_ruin", 3), Map.entry("swamp_hut", 4), Map.entry("trail_ruins", 6), Map.entry("trial_chambers", 7));
    private static final Map<String, Integer> BIOME_COSTS = Map.ofEntries(Map.entry("badlands", 4), Map.entry("bamboo_jungle", 5), Map.entry("basalt_deltas", 5), Map.entry("beach", 1), Map.entry("birch_forest", 2), Map.entry("cherry_grove", 6), Map.entry("cold_ocean", 2), Map.entry("crimson_forest", 5), Map.entry("dark_forest", 3), Map.entry("deep_cold_ocean", 3), Map.entry("deep_dark", 6), Map.entry("deep_frozen_ocean", 3), Map.entry("deep_lukewarm_ocean", 3), Map.entry("deep_ocean", 3), Map.entry("desert", 2), Map.entry("dripstone_caves", 4), Map.entry("end_barrens", 5), Map.entry("end_highlands", 6), Map.entry("end_midlands", 5), Map.entry("eroded_badlands", 5), Map.entry("flower_forest", 4), Map.entry("forest", 1), Map.entry("frozen_ocean", 3), Map.entry("frozen_peaks", 6), Map.entry("frozen_river", 2), Map.entry("grove", 4), Map.entry("ice_spikes", 6), Map.entry("jagged_peaks", 6), Map.entry("jungle", 4), Map.entry("lukewarm_ocean", 2), Map.entry("lush_caves", 5), Map.entry("mangrove_swamp", 5), Map.entry("meadow", 4), Map.entry("mushroom_fields", 7), Map.entry("nether_wastes", 3), Map.entry("ocean", 1), Map.entry("old_growth_birch_forest", 3), Map.entry("old_growth_pine_taiga", 3), Map.entry("old_growth_spruce_taiga", 3), Map.entry("plains", 1), Map.entry("river", 1), Map.entry("savanna", 3), Map.entry("savanna_plateau", 3), Map.entry("small_end_islands", 5), Map.entry("snowy_beach", 2), Map.entry("snowy_plains", 2), Map.entry("snowy_slopes", 5), Map.entry("snowy_taiga", 3), Map.entry("soul_sand_valley", 5), Map.entry("sparse_jungle", 4), Map.entry("stony_peaks", 5), Map.entry("stony_shore", 2), Map.entry("sunflower_plains", 2), Map.entry("swamp", 2), Map.entry("taiga", 2), Map.entry("the_end", 6), Map.entry("the_void", 10), Map.entry("warm_ocean", 2), Map.entry("warped_forest", 5), Map.entry("windswept_forest", 3), Map.entry("windswept_gravelly_hills", 3), Map.entry("windswept_hills", 3), Map.entry("windswept_savanna", 3), Map.entry("wooded_badlands", 4));
    private static final Map<String, Integer> POI_COSTS = Map.ofEntries(Map.entry("cartographer", 3), Map.entry("armorer", 3), Map.entry("librarian", 3), Map.entry("cleric", 3), Map.entry("butcher", 3), Map.entry("farmer", 2), Map.entry("fisherman", 2), Map.entry("shepherd", 2), Map.entry("toolsmith", 3), Map.entry("weaponsmith", 3));

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"locator").then(class_2170.method_9247((String)"structure").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> Locator.locate((CommandContext<class_2168>)ctx, "structure", StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"biome").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> Locator.locate((CommandContext<class_2168>)ctx, "biome", StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"poi").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> Locator.locate((CommandContext<class_2168>)ctx, "poi", StringArgumentType.getString((CommandContext)ctx, (String)"name")))))));
    }

    private static int locate(CommandContext<class_2168> ctx, String category, String name) throws CommandSyntaxException {
        int cost;
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        if (!Locator.hasEmeralds(player, cost = Locator.getCost(category, name.toLowerCase()))) {
            source.method_9213((class_2561)class_2561.method_43470((String)("You need " + cost + " emeralds to locate " + category + " '" + name + "'.")));
            return 0;
        }
        Locator.removeEmeralds(player, cost);
        String cmd = String.format("locate %s %s", category, name);
        return source.method_9211().method_3734().method_9235().execute(cmd, (Object)source);
    }

    private static int getCost(String category, String name) {
        switch (category) {
            case "structure": {
                return STRUCTURE_COSTS.getOrDefault(name, BASE_COST.get("structure"));
            }
            case "biome": {
                return BIOME_COSTS.getOrDefault(name, BASE_COST.get("biome"));
            }
            case "poi": {
                return POI_COSTS.getOrDefault(name, BASE_COST.get("poi"));
            }
        }
        return 5;
    }

    private static boolean hasEmeralds(class_3222 player, int cost) {
        int total = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7909() != class_1802.field_8687 || (total += stack.method_7947()) < cost) continue;
            return true;
        }
        return false;
    }

    private static void removeEmeralds(class_3222 player, int cost) {
        int remaining = cost;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7909() != class_1802.field_8687) continue;
            int take = Math.min(stack.method_7947(), remaining);
            stack.method_7934(take);
            if ((remaining -= take) > 0) continue;
            break;
        }
    }
}

