/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.textile.minecraft;

import java.net.URI;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dialog.Dialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\t\b\t\n\u000b\f\r\u000e\u000f\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0005\u0010\u0006\u0082\u0001\b\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent;", "", "<init>", "()V", "Lnet/minecraft/network/chat/ClickEvent;", "asVanilla", "()Lnet/minecraft/network/chat/ClickEvent;", "Companion", "OpenUrl", "OpenFile", "RunCommand", "SuggestCommand", "ChangePage", "CopyToClipboard", "ShowDialog", "Custom", "Ldev/deftu/textile/minecraft/MCClickEvent$ChangePage;", "Ldev/deftu/textile/minecraft/MCClickEvent$CopyToClipboard;", "Ldev/deftu/textile/minecraft/MCClickEvent$Custom;", "Ldev/deftu/textile/minecraft/MCClickEvent$OpenFile;", "Ldev/deftu/textile/minecraft/MCClickEvent$OpenUrl;", "Ldev/deftu/textile/minecraft/MCClickEvent$RunCommand;", "Ldev/deftu/textile/minecraft/MCClickEvent$ShowDialog;", "Ldev/deftu/textile/minecraft/MCClickEvent$SuggestCommand;", "textile"})
public abstract sealed class MCClickEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private MCClickEvent() {
    }

    @NotNull
    public abstract ClickEvent asVanilla();

    @JvmStatic
    @Nullable
    public static final MCClickEvent convertFromVanilla(@NotNull ClickEvent event) {
        return Companion.convertFromVanilla(event);
    }

    @JvmStatic
    @Nullable
    public static final ClickEvent convertToVanilla(@NotNull MCClickEvent event) {
        return Companion.convertToVanilla(event);
    }

    public /* synthetic */ MCClickEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\n\u00a8\u0006\u0018"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent$ChangePage;", "Ldev/deftu/textile/minecraft/MCClickEvent;", "", "page", "<init>", "(I)V", "Lnet/minecraft/network/chat/ClickEvent;", "asVanilla", "()Lnet/minecraft/network/chat/ClickEvent;", "component1", "()I", "copy", "(I)Ldev/deftu/textile/minecraft/MCClickEvent$ChangePage;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getPage", "textile"})
    public static final class ChangePage
    extends MCClickEvent {
        private final int page;

        public ChangePage(int page) {
            super(null);
            this.page = page;
        }

        public final int getPage() {
            return this.page;
        }

        @Override
        @NotNull
        public ClickEvent asVanilla() {
            return (ClickEvent)new ClickEvent.ChangePage(this.page);
        }

        public final int component1() {
            return this.page;
        }

        @NotNull
        public final ChangePage copy(int page) {
            return new ChangePage(page);
        }

        public static /* synthetic */ ChangePage copy$default(ChangePage changePage, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = changePage.page;
            }
            return changePage.copy(n);
        }

        @NotNull
        public String toString() {
            return "ChangePage(page=" + this.page + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.page);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChangePage)) {
                return false;
            }
            ChangePage changePage = (ChangePage)other;
            return this.page == changePage.page;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ$\u0010\u000e\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0082\b\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/chat/ClickEvent;", "event", "Ldev/deftu/textile/minecraft/MCClickEvent;", "convertFromVanilla", "(Lnet/minecraft/network/chat/ClickEvent;)Ldev/deftu/textile/minecraft/MCClickEvent;", "convertToVanilla", "(Ldev/deftu/textile/minecraft/MCClickEvent;)Lnet/minecraft/network/chat/ClickEvent;", "T", "Lkotlin/Function0;", "init", "noInline", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "textile"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final MCClickEvent convertFromVanilla(@NotNull ClickEvent event) {
            MCClickEvent mCClickEvent;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ClickEvent clickEvent = event;
            if (clickEvent instanceof ClickEvent.OpenUrl) {
                URI uRI = ((ClickEvent.OpenUrl)event).uri();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri(...)");
                mCClickEvent = new OpenUrl(uRI);
            } else if (clickEvent instanceof ClickEvent.OpenFile) {
                String string = ((ClickEvent.OpenFile)event).path();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path(...)");
                mCClickEvent = new OpenFile(string);
            } else if (clickEvent instanceof ClickEvent.RunCommand) {
                String string = ((ClickEvent.RunCommand)event).command();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"command(...)");
                mCClickEvent = new RunCommand(string);
            } else if (clickEvent instanceof ClickEvent.SuggestCommand) {
                String string = ((ClickEvent.SuggestCommand)event).command();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"command(...)");
                mCClickEvent = new SuggestCommand(string);
            } else {
                mCClickEvent = clickEvent instanceof ClickEvent.ChangePage ? (MCClickEvent)new ChangePage(((ClickEvent.ChangePage)event).page()) : null;
            }
            return mCClickEvent;
        }

        @JvmStatic
        @Nullable
        public final ClickEvent convertToVanilla(@NotNull MCClickEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            MCClickEvent mCClickEvent = event;
            return mCClickEvent instanceof OpenUrl ? (ClickEvent)new ClickEvent.OpenUrl(((OpenUrl)event).getUri()) : (mCClickEvent instanceof OpenFile ? (ClickEvent)new ClickEvent.OpenFile(((OpenFile)event).getPath()) : (mCClickEvent instanceof RunCommand ? (ClickEvent)new ClickEvent.RunCommand(((RunCommand)event).getCommand()) : (mCClickEvent instanceof SuggestCommand ? (ClickEvent)new ClickEvent.SuggestCommand(((SuggestCommand)event).getCommand()) : (mCClickEvent instanceof ChangePage ? (ClickEvent)new ClickEvent.ChangePage(((ChangePage)event).getPage()) : null))));
        }

        private final <T> T noInline(Function0<? extends T> init) {
            boolean $i$f$noInline = false;
            return (T)init.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\n\u00a8\u0006\u0018"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent$CopyToClipboard;", "Ldev/deftu/textile/minecraft/MCClickEvent;", "", "value", "<init>", "(Ljava/lang/String;)V", "Lnet/minecraft/network/chat/ClickEvent;", "asVanilla", "()Lnet/minecraft/network/chat/ClickEvent;", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/deftu/textile/minecraft/MCClickEvent$CopyToClipboard;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getValue", "textile"})
    public static final class CopyToClipboard
    extends MCClickEvent {
        @NotNull
        private final String value;

        public CopyToClipboard(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public ClickEvent asVanilla() {
            return (ClickEvent)new ClickEvent.CopyToClipboard(this.value);
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final CopyToClipboard copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new CopyToClipboard(value);
        }

        public static /* synthetic */ CopyToClipboard copy$default(CopyToClipboard copyToClipboard, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = copyToClipboard.value;
            }
            return copyToClipboard.copy(string);
        }

        @NotNull
        public String toString() {
            return "CopyToClipboard(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CopyToClipboard)) {
                return false;
            }
            CopyToClipboard copyToClipboard = (CopyToClipboard)other;
            return Intrinsics.areEqual((Object)this.value, (Object)copyToClipboard.value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ*\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\rR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001f\u001a\u0004\b \u0010\u000f\u00a8\u0006!"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent$Custom;", "Ldev/deftu/textile/minecraft/MCClickEvent;", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Ljava/util/Optional;", "Lnet/minecraft/nbt/Tag;", "nbt", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/Optional;)V", "Lnet/minecraft/network/chat/ClickEvent;", "asVanilla", "()Lnet/minecraft/network/chat/ClickEvent;", "component1", "()Lnet/minecraft/resources/ResourceLocation;", "component2", "()Ljava/util/Optional;", "copy", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/Optional;)Ldev/deftu/textile/minecraft/MCClickEvent$Custom;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/resources/ResourceLocation;", "getIdentifier", "Ljava/util/Optional;", "getNbt", "textile"})
    public static final class Custom
    extends MCClickEvent {
        @NotNull
        private final ResourceLocation identifier;
        @NotNull
        private final Optional<Tag> nbt;

        public Custom(@NotNull ResourceLocation identifier, @NotNull Optional<Tag> nbt) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter(nbt, (String)"nbt");
            super(null);
            this.identifier = identifier;
            this.nbt = nbt;
        }

        @NotNull
        public final ResourceLocation getIdentifier() {
            return this.identifier;
        }

        @NotNull
        public final Optional<Tag> getNbt() {
            return this.nbt;
        }

        @Override
        @NotNull
        public ClickEvent asVanilla() {
            return (ClickEvent)new ClickEvent.Custom(this.identifier, this.nbt);
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.identifier;
        }

        @NotNull
        public final Optional<Tag> component2() {
            return this.nbt;
        }

        @NotNull
        public final Custom copy(@NotNull ResourceLocation identifier, @NotNull Optional<Tag> nbt) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter(nbt, (String)"nbt");
            return new Custom(identifier, nbt);
        }

        public static /* synthetic */ Custom copy$default(Custom custom, ResourceLocation resourceLocation, Optional optional, int n, Object object) {
            if ((n & 1) != 0) {
                resourceLocation = custom.identifier;
            }
            if ((n & 2) != 0) {
                optional = custom.nbt;
            }
            return custom.copy(resourceLocation, optional);
        }

        @NotNull
        public String toString() {
            return "Custom(identifier=" + this.identifier + ", nbt=" + this.nbt + ")";
        }

        public int hashCode() {
            int result = this.identifier.hashCode();
            result = result * 31 + this.nbt.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Custom)) {
                return false;
            }
            Custom custom = (Custom)other;
            if (!Intrinsics.areEqual((Object)this.identifier, (Object)custom.identifier)) {
                return false;
            }
            return Intrinsics.areEqual(this.nbt, custom.nbt);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\n\u00a8\u0006\u0018"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent$OpenFile;", "Ldev/deftu/textile/minecraft/MCClickEvent;", "", "path", "<init>", "(Ljava/lang/String;)V", "Lnet/minecraft/network/chat/ClickEvent;", "asVanilla", "()Lnet/minecraft/network/chat/ClickEvent;", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/deftu/textile/minecraft/MCClickEvent$OpenFile;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getPath", "textile"})
    public static final class OpenFile
    extends MCClickEvent {
        @NotNull
        private final String path;

        public OpenFile(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(null);
            this.path = path;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public ClickEvent asVanilla() {
            return (ClickEvent)new ClickEvent.OpenFile(this.path);
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final OpenFile copy(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new OpenFile(path);
        }

        public static /* synthetic */ OpenFile copy$default(OpenFile openFile, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = openFile.path;
            }
            return openFile.copy(string);
        }

        @NotNull
        public String toString() {
            return "OpenFile(path=" + this.path + ")";
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OpenFile)) {
                return false;
            }
            OpenFile openFile = (OpenFile)other;
            return Intrinsics.areEqual((Object)this.path, (Object)openFile.path);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\n\u00a8\u0006\u001a"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent$OpenUrl;", "Ldev/deftu/textile/minecraft/MCClickEvent;", "Ljava/net/URI;", "uri", "<init>", "(Ljava/net/URI;)V", "Lnet/minecraft/network/chat/ClickEvent;", "asVanilla", "()Lnet/minecraft/network/chat/ClickEvent;", "component1", "()Ljava/net/URI;", "copy", "(Ljava/net/URI;)Ldev/deftu/textile/minecraft/MCClickEvent$OpenUrl;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/net/URI;", "getUri", "textile"})
    public static final class OpenUrl
    extends MCClickEvent {
        @NotNull
        private final URI uri;

        public OpenUrl(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            super(null);
            this.uri = uri;
        }

        @NotNull
        public final URI getUri() {
            return this.uri;
        }

        @Override
        @NotNull
        public ClickEvent asVanilla() {
            return (ClickEvent)new ClickEvent.OpenUrl(this.uri);
        }

        @NotNull
        public final URI component1() {
            return this.uri;
        }

        @NotNull
        public final OpenUrl copy(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return new OpenUrl(uri);
        }

        public static /* synthetic */ OpenUrl copy$default(OpenUrl openUrl, URI uRI, int n, Object object) {
            if ((n & 1) != 0) {
                uRI = openUrl.uri;
            }
            return openUrl.copy(uRI);
        }

        @NotNull
        public String toString() {
            return "OpenUrl(uri=" + this.uri + ")";
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OpenUrl)) {
                return false;
            }
            OpenUrl openUrl = (OpenUrl)other;
            return Intrinsics.areEqual((Object)this.uri, (Object)openUrl.uri);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\n\u00a8\u0006\u0018"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent$RunCommand;", "Ldev/deftu/textile/minecraft/MCClickEvent;", "", "command", "<init>", "(Ljava/lang/String;)V", "Lnet/minecraft/network/chat/ClickEvent;", "asVanilla", "()Lnet/minecraft/network/chat/ClickEvent;", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/deftu/textile/minecraft/MCClickEvent$RunCommand;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getCommand", "textile"})
    public static final class RunCommand
    extends MCClickEvent {
        @NotNull
        private final String command;

        public RunCommand(@NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            super(null);
            this.command = command;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @Override
        @NotNull
        public ClickEvent asVanilla() {
            return (ClickEvent)new ClickEvent.RunCommand(this.command);
        }

        @NotNull
        public final String component1() {
            return this.command;
        }

        @NotNull
        public final RunCommand copy(@NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return new RunCommand(command);
        }

        public static /* synthetic */ RunCommand copy$default(RunCommand runCommand, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = runCommand.command;
            }
            return runCommand.copy(string);
        }

        @NotNull
        public String toString() {
            return "RunCommand(command=" + this.command + ")";
        }

        public int hashCode() {
            return this.command.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RunCommand)) {
                return false;
            }
            RunCommand runCommand = (RunCommand)other;
            return Intrinsics.areEqual((Object)this.command, (Object)runCommand.command);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001a\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent$ShowDialog;", "Ldev/deftu/textile/minecraft/MCClickEvent;", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/server/dialog/Dialog;", "dialogEntry", "<init>", "(Lnet/minecraft/core/Holder;)V", "Lnet/minecraft/network/chat/ClickEvent;", "asVanilla", "()Lnet/minecraft/network/chat/ClickEvent;", "component1", "()Lnet/minecraft/core/Holder;", "copy", "(Lnet/minecraft/core/Holder;)Ldev/deftu/textile/minecraft/MCClickEvent$ShowDialog;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/core/Holder;", "getDialogEntry", "textile"})
    public static final class ShowDialog
    extends MCClickEvent {
        @NotNull
        private final Holder<Dialog> dialogEntry;

        public ShowDialog(@NotNull Holder<Dialog> dialogEntry) {
            Intrinsics.checkNotNullParameter(dialogEntry, (String)"dialogEntry");
            super(null);
            this.dialogEntry = dialogEntry;
        }

        @NotNull
        public final Holder<Dialog> getDialogEntry() {
            return this.dialogEntry;
        }

        @Override
        @NotNull
        public ClickEvent asVanilla() {
            return (ClickEvent)new ClickEvent.ShowDialog(this.dialogEntry);
        }

        @NotNull
        public final Holder<Dialog> component1() {
            return this.dialogEntry;
        }

        @NotNull
        public final ShowDialog copy(@NotNull Holder<Dialog> dialogEntry) {
            Intrinsics.checkNotNullParameter(dialogEntry, (String)"dialogEntry");
            return new ShowDialog(dialogEntry);
        }

        public static /* synthetic */ ShowDialog copy$default(ShowDialog showDialog, Holder holder, int n, Object object) {
            if ((n & 1) != 0) {
                holder = showDialog.dialogEntry;
            }
            return showDialog.copy(holder);
        }

        @NotNull
        public String toString() {
            return "ShowDialog(dialogEntry=" + this.dialogEntry + ")";
        }

        public int hashCode() {
            return this.dialogEntry.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShowDialog)) {
                return false;
            }
            ShowDialog showDialog = (ShowDialog)other;
            return Intrinsics.areEqual(this.dialogEntry, showDialog.dialogEntry);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\n\u00a8\u0006\u0018"}, d2={"Ldev/deftu/textile/minecraft/MCClickEvent$SuggestCommand;", "Ldev/deftu/textile/minecraft/MCClickEvent;", "", "command", "<init>", "(Ljava/lang/String;)V", "Lnet/minecraft/network/chat/ClickEvent;", "asVanilla", "()Lnet/minecraft/network/chat/ClickEvent;", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/deftu/textile/minecraft/MCClickEvent$SuggestCommand;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getCommand", "textile"})
    public static final class SuggestCommand
    extends MCClickEvent {
        @NotNull
        private final String command;

        public SuggestCommand(@NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            super(null);
            this.command = command;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @Override
        @NotNull
        public ClickEvent asVanilla() {
            return (ClickEvent)new ClickEvent.SuggestCommand(this.command);
        }

        @NotNull
        public final String component1() {
            return this.command;
        }

        @NotNull
        public final SuggestCommand copy(@NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return new SuggestCommand(command);
        }

        public static /* synthetic */ SuggestCommand copy$default(SuggestCommand suggestCommand, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = suggestCommand.command;
            }
            return suggestCommand.copy(string);
        }

        @NotNull
        public String toString() {
            return "SuggestCommand(command=" + this.command + ")";
        }

        public int hashCode() {
            return this.command.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuggestCommand)) {
                return false;
            }
            SuggestCommand suggestCommand = (SuggestCommand)other;
            return Intrinsics.areEqual((Object)this.command, (Object)suggestCommand.command);
        }
    }
}

