/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.tools.common;

import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.IModModule;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Version;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.common.config.CosmereModConfig;
import leaf.cosmere.tools.common.capabilities.ToolsSpiritwebSubmodule;
import leaf.cosmere.tools.common.config.ToolsConfigs;
import leaf.cosmere.tools.common.registries.ToolsAttributes;
import leaf.cosmere.tools.common.registries.ToolsBiomeModifiers;
import leaf.cosmere.tools.common.registries.ToolsBiomes;
import leaf.cosmere.tools.common.registries.ToolsBlocks;
import leaf.cosmere.tools.common.registries.ToolsCreativeTabs;
import leaf.cosmere.tools.common.registries.ToolsEffects;
import leaf.cosmere.tools.common.registries.ToolsEntityTypes;
import leaf.cosmere.tools.common.registries.ToolsFeatures;
import leaf.cosmere.tools.common.registries.ToolsItems;
import leaf.cosmere.tools.common.registries.ToolsManifestations;
import leaf.cosmere.tools.common.registries.ToolsMenuTypes;
import leaf.cosmere.tools.common.registries.ToolsRecipes;
import leaf.cosmere.tools.common.registries.ToolsStats;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="cosmeretools")
public class CosmereTools
implements IModModule {
    public static final String MODID = "cosmeretools";
    public static CosmereTools instance;
    public final Version versionNumber;

    public CosmereTools() {
        instance = this;
        Cosmere.addModule((IModModule)instance);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ToolsConfigs.registerConfigs(ModLoadingContext.get());
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::onConfigLoad);
        modBus.addListener(this::onConfigReload);
        modBus.addListener(this::imcQueue);
        ToolsAttributes.ATTRIBUTES.register(modBus);
        ToolsBiomes.BIOMES.register(modBus);
        ToolsBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(modBus);
        ToolsBlocks.BLOCKS.register(modBus);
        ToolsEffects.EFFECTS.register(modBus);
        ToolsFeatures.CONFIGURED_FEATURES.register(modBus);
        ToolsFeatures.PLACED_FEATURES.register(modBus);
        ToolsEntityTypes.ENTITY_TYPES.register(modBus);
        ToolsItems.ITEMS.register(modBus);
        ToolsManifestations.MANIFESTATIONS.register(modBus);
        ToolsMenuTypes.MENU_TYPES.register(modBus);
        ToolsRecipes.SPECIAL_RECIPES.register(modBus);
        ToolsStats.STATS.register(modBus);
        ToolsCreativeTabs.CREATIVE_TABS.register(modBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CosmereAPI.logger.info("Cosmere: Tools module Version {} initializing...", (Object)this.versionNumber);
        event.enqueueWork(() -> ToolsStats.initStatEntries());
    }

    private void imcQueue(InterModEnqueueEvent event) {
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Cosmere: Tools";
    }

    public ISpiritwebSubmodule makeSubmodule() {
        return new ToolsSpiritwebSubmodule();
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof CosmereModConfig) {
            CosmereModConfig cosmereModConfig = (CosmereModConfig)config;
            cosmereModConfig.clearCache();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof CosmereModConfig) {
            CosmereModConfig cosmereModConfig = (CosmereModConfig)config;
            cosmereModConfig.clearCache();
        }
    }
}

