/*
 * Decompiled with CFR 0.152.
 */
package cameratweaks.config;

import cameratweaks.Keybinds;
import java.util.function.Function;
import net.minecraft.class_3532;

public enum TransitionType {
    INSTANT(x -> Float.valueOf(Keybinds.zoom.enabled() ? 1.0f : 0.0f)),
    LINEAR(x -> x),
    SINE_IN(x -> Float.valueOf(1.0f - class_3532.method_15362((float)(x.floatValue() * (float)Math.PI / 2.0f))), x -> Float.valueOf((float)StrictMath.acos((double)(-x.floatValue()) + 1.0) * 2.0f / (float)Math.PI)),
    SINE_OUT(x -> Float.valueOf(class_3532.method_15374((float)(x.floatValue() * (float)Math.PI / 2.0f))), x -> Float.valueOf((float)StrictMath.asin(x.floatValue()) * 2.0f / (float)Math.PI)),
    SINE_IN_OUT(x -> Float.valueOf(0.5f - class_3532.method_15362((float)((float)Math.PI * x.floatValue())) / 2.0f)),
    QUAD_IN(2),
    QUAD_OUT(2),
    QUAD_IN_OUT(2),
    CUBIC_IN(3),
    CUBIC_OUT(3),
    CUBIC_IN_OUT(3),
    QUART_IN(4),
    QUART_OUT(4),
    QUART_IN_OUT(4),
    QUINT_IN(5),
    QUINT_OUT(5),
    QUINT_IN_OUT(5),
    EXPO_IN(x -> Float.valueOf((float)StrictMath.pow(2.0, 10.0 * (double)x.floatValue() - 10.0)), x -> Float.valueOf(1.0f + (float)StrictMath.log(x.floatValue()) / ((float)StrictMath.log(2.0) / 10.0f))),
    EXPO_OUT(x -> Float.valueOf(1.0f - (float)StrictMath.pow(2.0, -10.0 * (double)x.floatValue())), x -> Float.valueOf((float)(-StrictMath.log(1.0 - (double)x.floatValue())) / ((float)StrictMath.log(2.0) / 10.0f))),
    EXPO_IN_OUT(x -> Float.valueOf(x.floatValue() < 0.5f ? (float)StrictMath.pow(2.0, 20.0f * x.floatValue() - 10.0f) / 2.0f : (2.0f - (float)StrictMath.pow(2.0, -20.0f * x.floatValue() + 10.0f)) / 2.0f)),
    CIRC_IN(x -> Float.valueOf(1.0f - class_3532.method_15355((float)(1.0f - x.floatValue() * x.floatValue()))), x -> Float.valueOf(1.0f - class_3532.method_15355((float)(1.0f - (1.0f - x.floatValue()) * (1.0f - x.floatValue()))))),
    CIRC_OUT(x -> Float.valueOf(class_3532.method_15355((float)(1.0f - (x.floatValue() - 1.0f) * (x.floatValue() - 1.0f)))), x -> Float.valueOf(class_3532.method_15355((float)(1.0f - x.floatValue() * x.floatValue())))),
    CIRC_IN_OUT(x -> Float.valueOf(x.floatValue() < 0.5f ? (1.0f - class_3532.method_15355((float)(1.0f - (float)StrictMath.pow(2.0 * (double)x.floatValue(), 2.0)))) / 2.0f : (class_3532.method_15355((float)(1.0f - (float)StrictMath.pow(-2.0 * (double)x.floatValue() + 2.0, 2.0))) + 1.0f) / 2.0f));

    private final Function<Float, Float> function;
    private final Function<Float, Float> inverse;

    private TransitionType(int i) {
        if (this.name().endsWith("_IN")) {
            this.function = x -> Float.valueOf((float)StrictMath.pow(x.floatValue(), i));
            this.inverse = x -> Float.valueOf(1.0f - (float)StrictMath.pow(1.0 - (double)x.floatValue(), i));
        } else if (this.name().endsWith("_IN_OUT")) {
            float mul = (float)StrictMath.pow(2.0, (double)i - 1.0);
            this.function = x -> Float.valueOf(x.floatValue() < 0.5f ? mul * (float)StrictMath.pow(x.floatValue(), i) : 1.0f - (float)StrictMath.pow(-2.0 * (double)x.floatValue() + 2.0, x.floatValue()) / 2.0f);
            this.inverse = null;
        } else {
            this.function = x -> Float.valueOf(1.0f - (float)StrictMath.pow(1.0 - (double)x.floatValue(), i));
            this.inverse = x -> Float.valueOf(1.0f - (float)StrictMath.pow(1.0 - (double)x.floatValue(), 1.0 / (double)i));
        }
    }

    private TransitionType(Function<Float, Float> function) {
        this(function, null);
    }

    private TransitionType(Function<Float, Float> function, Function<Float, Float> inverse) {
        this.function = function;
        this.inverse = inverse;
    }

    public float apply(float x) {
        return x <= 0.0f ? 0.0f : (x >= 1.0f ? 1.0f : this.function.apply(Float.valueOf(x)).floatValue());
    }

    public float inverse(float x) {
        return x <= 0.0f ? 0.0f : (x >= 1.0f ? 1.0f : this.inverse.apply(Float.valueOf(this.opposite().apply(x))).floatValue());
    }

    public boolean hasInverse() {
        return this.inverse != null;
    }

    public TransitionType opposite() {
        if (this.name().endsWith("_IN")) {
            return TransitionType.values()[this.ordinal() + 1];
        }
        if (this.name().endsWith("_OUT") && !this.name().endsWith("_IN_OUT")) {
            return TransitionType.values()[this.ordinal() - 1];
        }
        return this;
    }
}

