package co.secretonline.clientsidepaintingvariants;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import org.slf4j.Logger;

import com.google.gson.JsonObject;

import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1535;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class PaintingVariantsDataListener implements IdentifiableResourceReloadListener {
	private static Logger LOGGER = ClientSidePaintingVariants.LOGGER;

	@Override
	public CompletableFuture<Void> method_25931(class_4045 synchronizer, class_3300 resourceManager,
			Executor prepareExecutor, Executor applyExecutor) {
		return CompletableFuture
				.supplyAsync(
						() -> this.getPaintingsFromData(resourceManager),
						prepareExecutor)
				.thenCompose(synchronizer::method_18352)
				.thenAcceptAsync(
						(paintings) -> PaintingsInfo.getInstance().setRegistryPaintings(paintings),
						applyExecutor);
	}

	/**
	 * Note: This method is similar to the one in
	 * {@link PaintingVariantsResourceListener}.
	 * If making changes here, be sure to also change there too.
	 */
	private Map<class_2960, class_1535> getPaintingsFromData(class_3300 resourceManager) {
		Map<class_2960, class_1535> paintings = new HashMap<>();

		// Load all files from resource packs that should contain painting variants.
		// Vanilla paintings shouldn't appear in this list, as this is reading from
		// resources and not data.
		var allVariantJsonFiles = resourceManager.method_14488(
				"painting_variant",
				identifier -> identifier.method_12832().endsWith(".json"));

		allVariantJsonFiles.forEach((identifier, resource) -> {
			try (var reader = resource.method_43039()) {
				JsonObject data = class_3518.method_15255(reader).getAsJsonObject();
				int width = data.get("width").getAsInt();
				int height = data.get("height").getAsInt();

				class_2960 assetId = class_2960.method_60654(data.get("asset_id").getAsString());

				// TODO: Read text components
				paintings.put(identifier, new class_1535(width, height, assetId, Optional.empty(), Optional.empty()));
			} catch (IOException ex) {
				LOGGER.warn("Failed to read data for registry painting variant " + identifier.toString() + ". Skipping");
			} catch (Exception ex) {
				LOGGER.warn("Error while reading registry painting variant " + identifier.toString() + ". Skipping");
			}
		});

		return paintings;
	}

	@Override
	public class_2960 getFabricId() {
		return ClientSidePaintingVariants.id("data-listener");
	}
}
