package co.secretonline.clientsidepaintingvariants.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import co.secretonline.clientsidepaintingvariants.PaintingsInfo;
import net.minecraft.class_10049;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_928;

@Mixin(class_928.class)
public class PaintingEntityRendererMixin {
	@Inject(method = "updateRenderState", at = @At("RETURN"))
	private void injectUpdateRenderState(class_1534 paintingEntity,
			class_10049 paintingEntityRenderState, float f, CallbackInfo ci) {
		class_1535 paintingVariant = (class_1535) paintingEntity.method_43404().comp_349();

		PaintingsInfo paintingInfo = PaintingsInfo.getInstance();
		var registryPaintings = paintingInfo.getRegistryPaintingsForSize(paintingVariant.comp_2670(),
				paintingVariant.comp_2671());
		var resourcePaintings = paintingInfo.getResourcePaintingsForSize(paintingVariant.comp_2670(),
				paintingVariant.comp_2671());

		if (registryPaintings == null || resourcePaintings == null ||
				resourcePaintings.isEmpty()) {
			return;
		}
		int numRegistered = registryPaintings.size();
		int numAdded = resourcePaintings.size();
		int numTotal = numRegistered + numAdded;

		// Use the hash of the UUID as a stable random value for this entity.
		int hash = paintingEntity.method_5667().hashCode();

		// % can be negative, so add the total and % again for the proper modulo.
		int modulo = ((hash % (numTotal)) + numTotal) % numTotal;
		if (modulo < numRegistered) {
			return;
		}

		int index = modulo - numRegistered;
		var newVariant = resourcePaintings.get(index);
		if (newVariant == null) {
			// If this happens, then something has gone wrong.
			return;
		}

		paintingEntityRenderState.field_53497 = newVariant;
	}
}
