/*
 * Decompiled with CFR 0.152.
 */
package co.secretonline.clientsidepaintingvariants;

import co.secretonline.clientsidepaintingvariants.ClientSidePaintingVariants;
import co.secretonline.clientsidepaintingvariants.PaintingsInfo;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1535;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class PaintingVariantsDataListener
implements class_3302 {
    private static Logger LOGGER = ClientSidePaintingVariants.LOGGER;

    public CompletableFuture<Void> method_25931(class_3302.class_11558 store, Executor prepareExecutor, class_3302.class_4045 reloadSynchronizer, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getPaintingsFromData(store.method_72361()), prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)reloadSynchronizer).method_18352(arg_0))).thenAcceptAsync(paintings -> PaintingsInfo.getInstance().setRegistryPaintings((Map<class_2960, class_1535>)paintings), applyExecutor);
    }

    private Map<class_2960, class_1535> getPaintingsFromData(class_3300 resourceManager) {
        HashMap<class_2960, class_1535> paintings = new HashMap<class_2960, class_1535>();
        Map allVariantJsonFiles = resourceManager.method_14488("painting_variant", identifier -> identifier.method_12832().endsWith(".json"));
        allVariantJsonFiles.forEach((identifier, resource) -> {
            try (BufferedReader reader = resource.method_43039();){
                JsonObject data = class_3518.method_15255((Reader)reader).getAsJsonObject();
                int width = data.get("width").getAsInt();
                int height = data.get("height").getAsInt();
                class_2960 assetId = class_2960.method_60654((String)data.get("asset_id").getAsString());
                paintings.put((class_2960)identifier, new class_1535(width, height, assetId, Optional.empty(), Optional.empty()));
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to read data for registry painting variant " + identifier.toString() + ". Skipping");
            }
            catch (Exception ex) {
                LOGGER.warn("Error while reading registry painting variant " + identifier.toString() + ". Skipping");
            }
        });
        return paintings;
    }
}

