/*
 * Decompiled with CFR 0.152.
 */
package co.secretonline.clientsidepaintingvariants;

import co.secretonline.clientsidepaintingvariants.ClientSidePaintingVariants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1535;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class PaintingsInfo {
    private static Logger LOGGER = ClientSidePaintingVariants.LOGGER;
    private static PaintingsInfo INSTANCE = null;
    private Map<class_2960, class_1535> registryPaintings;
    private Map<class_2960, class_1535> resourcePaintings;
    private Map<String, PaintingsForSize> resolvedPaintingsMap = new HashMap<String, PaintingsForSize>();

    public static PaintingsInfo getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PaintingsInfo();
        }
        return INSTANCE;
    }

    private static String toKey(int a, int b) {
        return a + "x" + b;
    }

    private PaintingsInfo() {
    }

    public void setRegistryPaintings(Map<class_2960, class_1535> paintings) {
        this.registryPaintings = paintings;
        this.resolvePaintings();
    }

    public void setResourcePaintings(Map<class_2960, class_1535> paintings) {
        this.resourcePaintings = paintings;
        this.resolvePaintings();
    }

    private boolean resolvePaintings() {
        if (this.registryPaintings == null && this.resourcePaintings == null) {
            LOGGER.warn("Waiting for world data and resources to be loaded");
            return false;
        }
        if (this.registryPaintings != null && this.resourcePaintings == null) {
            LOGGER.warn("Waiting for resources to be loaded");
            return false;
        }
        if (this.registryPaintings == null && this.resourcePaintings != null) {
            LOGGER.warn("Waiting for world data to be loaded");
            return false;
        }
        this.resolvedPaintingsMap.clear();
        this.registryPaintings.forEach((id, variant) -> {
            String key = PaintingsInfo.toKey(variant.comp_2670(), variant.comp_2671());
            if (!this.resolvedPaintingsMap.containsKey(key)) {
                this.resolvedPaintingsMap.put(key, new PaintingsForSize());
            }
            PaintingsForSize forSize = this.resolvedPaintingsMap.get(key);
            forSize.registryPaintings.put((class_2960)id, (class_1535)variant);
        });
        this.resourcePaintings.forEach((id, variant) -> {
            String key = PaintingsInfo.toKey(variant.comp_2670(), variant.comp_2671());
            if (!this.resolvedPaintingsMap.containsKey(key)) {
                this.resolvedPaintingsMap.put(key, new PaintingsForSize());
            }
            PaintingsForSize forSize = this.resolvedPaintingsMap.get(key);
            if (forSize.registryPaintings.containsKey(id)) {
                LOGGER.warn("Resource painting " + id.toString() + " is already defined in the registry");
                return;
            }
            forSize.resourcePaintings.put((class_2960)id, (class_1535)variant);
        });
        LOGGER.info(this.getSummaryString());
        return true;
    }

    public String getSummaryString() {
        int numPaintings = 0;
        ArrayList<String> sizeSummaries = new ArrayList<String>(this.resolvedPaintingsMap.size());
        for (Map.Entry<String, PaintingsForSize> entry : this.resolvedPaintingsMap.entrySet()) {
            String key = entry.getKey();
            PaintingsForSize paintings = entry.getValue();
            numPaintings += paintings.registryPaintings.size() + paintings.resourcePaintings.size();
            sizeSummaries.add(key + " (" + paintings.registryPaintings.size() + "+" + paintings.resourcePaintings.size() + ")");
        }
        StringBuilder sb = new StringBuilder().append(numPaintings).append(" paintings for ").append(this.resolvedPaintingsMap.size()).append(" sizes: ").append(String.join((CharSequence)", ", sizeSummaries));
        return sb.toString();
    }

    @Nullable
    public List<class_1535> getRegistryPaintingsForSize(int width, int height) {
        PaintingsForSize forSize = this.resolvedPaintingsMap.get(PaintingsInfo.toKey(width, height));
        if (forSize == null) {
            return null;
        }
        return forSize.getRegistryPaintings();
    }

    @Nullable
    public List<class_1535> getResourcePaintingsForSize(int width, int height) {
        PaintingsForSize forSize = this.resolvedPaintingsMap.get(PaintingsInfo.toKey(width, height));
        if (forSize == null) {
            return null;
        }
        return forSize.getResourcePaintings();
    }

    @Environment(value=EnvType.CLIENT)
    public static class PaintingsForSize {
        private Map<class_2960, class_1535> registryPaintings = new HashMap<class_2960, class_1535>();
        private Map<class_2960, class_1535> resourcePaintings = new HashMap<class_2960, class_1535>();

        public List<class_1535> getRegistryPaintings() {
            return List.copyOf(this.registryPaintings.values());
        }

        public List<class_1535> getResourcePaintings() {
            return List.copyOf(this.resourcePaintings.values());
        }
    }
}

