/*
 * Decompiled with CFR 0.152.
 */
package com.greenmods.canonnukes;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearSirenBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearExplosionEntity;
import com.google.common.base.Predicates;
import com.greenmods.canonnukes.CanonNukes;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.index.CBCMunitionPropertiesHandlers;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonCommonShellProperties;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonFuzePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonProjectilePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.EntityDamagePropertiesComponent;

public class NukeShellProjectile
extends FuzedBigCannonProjectile {
    public NukeShellProjectile(EntityType<? extends NukeShellProjectile> type, Level level) {
        super(type, level);
    }

    protected void detonate(Position position) {
        NuclearExplosionEntity explosion = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(this.m_9236_());
        explosion.m_20359_((Entity)this);
        explosion.setSize(((Double)AlexsCaves.COMMON_CONFIG.nukeExplosionSizeModifier.get()).floatValue() * this.getAllProperties().explosion().explosivePower());
        this.m_9236_().m_7967_((Entity)explosion);
        this.m_146870_();
    }

    protected void onTickRotate() {
        super.onTickRotate();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.f_19797_ % 10 == 0) {
                this.getNearbySirens(server, 256).forEach(pos -> {
                    BlockEntity patt2634$temp = server.m_7702_(pos);
                    if (patt2634$temp instanceof NuclearSirenBlockEntity) {
                        NuclearSirenBlockEntity siren = (NuclearSirenBlockEntity)patt2634$temp;
                        siren.setNearestNuclearBomb((Entity)this);
                    }
                });
            }
        }
    }

    public BlockState getRenderedBlockState() {
        return (BlockState)CanonNukes.NUKE_SHELL.getDefaultState().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH);
    }

    @Nonnull
    protected BigCannonFuzePropertiesComponent getFuzeProperties() {
        return this.getAllProperties().fuze();
    }

    @Nonnull
    protected BigCannonProjectilePropertiesComponent getBigCannonProjectileProperties() {
        return this.getAllProperties().bigCannonProperties();
    }

    @Nonnull
    public EntityDamagePropertiesComponent getDamageProperties() {
        return this.getAllProperties().damage();
    }

    @Nonnull
    protected BallisticPropertiesComponent getBallisticProperties() {
        return this.getAllProperties().ballistics();
    }

    protected BigCannonCommonShellProperties getAllProperties() {
        return (BigCannonCommonShellProperties)CBCMunitionPropertiesHandlers.COMMON_SHELL_BIG_CANNON_PROJECTILE.getPropertiesOf((Entity)this);
    }

    private Stream<BlockPos> getNearbySirens(ServerLevel world, int range) {
        PoiManager poiManager = world.m_8904_();
        return poiManager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.NUCLEAR_SIREN.getKey()), (Predicate)Predicates.alwaysTrue(), this.m_20183_(), range, PoiManager.Occupancy.ANY);
    }
}

