/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge;

import fr.lanfix.randomitemchallenge.commands.RandomItemChallengeCommand;
import fr.lanfix.randomitemchallenge.events.GameEvents;
import fr.lanfix.randomitemchallenge.events.ItemEvents;
import fr.lanfix.randomitemchallenge.game.Game;
import fr.lanfix.randomitemchallenge.game.scenario.Configuration;
import fr.lanfix.randomitemchallenge.placeholderapi.RandomItemChallengeExpansion;
import fr.lanfix.randomitemchallenge.scoreboard.NoScoreboard;
import fr.lanfix.randomitemchallenge.scoreboard.ScoreboardManager;
import fr.lanfix.randomitemchallenge.utils.Text;
import fr.lanfix.randomitemchallenge.world.WorldManager;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class RandomItemChallenge
extends JavaPlugin {
    private Game game;
    private Text text;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadTexts();
        this.loadGame();
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new GameEvents(this.game), (Plugin)this);
        pluginManager.registerEvents((Listener)new ItemEvents(this.game), (Plugin)this);
        PluginCommand RICCommand = this.getCommand("randomitemchallenge");
        assert (RICCommand != null);
        RICCommand.setExecutor((CommandExecutor)new RandomItemChallengeCommand(this, this.game, this.text));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new RandomItemChallengeExpansion(this.game).register();
        }
    }

    private void loadTexts() {
        this.saveResource("texts.yml", false);
        File textsFile = new File(this.getDataFolder(), "texts.yml");
        this.text = new Text(YamlConfiguration.loadConfiguration((File)textsFile));
    }

    private void loadGame() {
        this.saveResource("scoreboard.yml", false);
        File scoreboardFile = new File(this.getDataFolder(), "scoreboard.yml");
        YamlConfiguration sbConfig = YamlConfiguration.loadConfiguration((File)scoreboardFile);
        boolean customScoreboard = sbConfig.getBoolean("custom-scoreboard");
        boolean PAPIEnabled = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        ScoreboardManager sb = customScoreboard ? new ScoreboardManager(this.game, sbConfig.getStringList("scoreboard"), PAPIEnabled) : new NoScoreboard();
        WorldManager.createWorldManager(this.getConfig().getStringList("biomes-blacklist"), this.getConfig().getInt("border", 500), this.getConfig().getBoolean("use-separate-world", true));
        Configuration.loadScenarios(this);
        if (Configuration.defaultScenario == null) {
            Bukkit.getLogger().warning("[RandomItemChallenge] Unknown default scenario, please edit the configuration.");
        }
        this.game = new Game(this, this.text, sb);
        sb.setGame(this.game);
    }

    public void onDisable() {
        if (this.game.isRunning()) {
            this.game.stop();
        }
    }

    public void saveDefaultConfig() {
        File scenariosFolder;
        super.saveDefaultConfig();
        YamlConfiguration config = (YamlConfiguration)this.getConfig();
        String configVersion = config.getString("config-version", "1.2");
        if (configVersion.startsWith("1.")) {
            Bukkit.getLogger().warning("[Random Item Challenge] Found old Configuration file of older version (<2.0).");
            Bukkit.getLogger().warning("Please delete the RandomItemChallenge folder if you want to play with the new version (it introduces many breaking changes).");
            Bukkit.getLogger().info("You can make a backup of your old config if you liked it, in order to put your options into your own scenario");
        }
        if (!(scenariosFolder = new File(this.getDataFolder(), "scenarios")).exists()) {
            scenariosFolder.mkdirs();
        }
        this.saveDefaultResources();
    }

    private void saveDefaultResources() {
        String jarPath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        jarPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8);
        try (JarFile jar = new JarFile(jarPath);){
            jar.stream().forEach(jarEntry -> {
                File outFile;
                String name = jarEntry.getName();
                if ((name.startsWith("scenarios/") || name.startsWith("custom_drops/")) && !(outFile = new File(this.getDataFolder(), name)).exists()) {
                    this.saveResource(name, false);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

