/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge.events;

import fr.lanfix.randomitemchallenge.game.Game;
import fr.lanfix.randomitemchallenge.world.WorldManager;
import org.bukkit.GameMode;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.WorldEvent;

public class GameEvents
implements Listener {
    private final Game game;

    public GameEvents(Game game) {
        this.game = game;
    }

    @EventHandler
    public void onLoseHunger(FoodLevelChangeEvent event) {
        if (this.game.isRunning()) {
            event.setFoodLevel(20);
        }
    }

    @EventHandler
    public void onPortalCreate(PortalCreateEvent event) {
        if (this.game.isRunning() && WorldManager.getWorldManager().isEventInGameWorld((WorldEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        LivingEntity livingEntity;
        if (this.game.isRunning() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            player.setGameMode(GameMode.SPECTATOR);
            this.game.playerDeath(player);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        if (this.game.isRunning()) {
            this.game.playerDeath(event.getPlayer());
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        if (this.game.isRunning()) {
            this.game.playerDeath(event.getPlayer());
        }
    }
}

