/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge.game;

import fr.lanfix.randomitemchallenge.RandomItemChallenge;
import fr.lanfix.randomitemchallenge.api.event.RandomItemChallengeStartEvent;
import fr.lanfix.randomitemchallenge.api.event.RandomItemChallengeStopEvent;
import fr.lanfix.randomitemchallenge.api.event.RandomItemChallengeUpdateEvent;
import fr.lanfix.randomitemchallenge.game.Tracker;
import fr.lanfix.randomitemchallenge.game.scenario.Configuration;
import fr.lanfix.randomitemchallenge.game.scenario.Scenario;
import fr.lanfix.randomitemchallenge.scoreboard.ScoreboardManager;
import fr.lanfix.randomitemchallenge.utils.Text;
import fr.lanfix.randomitemchallenge.world.WorldManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;

public class Game {
    private final RandomItemChallenge plugin;
    private final WorldManager worldManager;
    private final Text text;
    private final ScoreboardManager sb;
    private Scenario scenario;
    private boolean running;
    private BukkitRunnable gameLoop;
    private final List<Player> players;
    private final List<Player> spectators;
    private String leaderboard;
    private final int durationHours;
    private final int durationMin;
    private int hours;
    private int min;
    private int sec;

    public Game(RandomItemChallenge plugin, Text text, ScoreboardManager sb) {
        this.plugin = plugin;
        this.text = text;
        this.sb = sb;
        this.scenario = Configuration.defaultScenario;
        this.worldManager = WorldManager.getWorldManager();
        this.running = false;
        this.players = new ArrayList<Player>();
        this.spectators = new ArrayList<Player>();
        this.durationHours = plugin.getConfig().getInt("game-duration.hours", 2);
        this.durationMin = plugin.getConfig().getInt("game-duration.minutes", 0);
    }

    public void start(Scenario scenario) {
        this.scenario = scenario;
        this.start();
    }

    public void start() {
        Bukkit.getPluginManager().callEvent((Event)new RandomItemChallengeStartEvent(this));
        Bukkit.getLogger().log(Level.INFO, this.text.getLog("start"));
        Location spawnLocation = this.worldManager.getSpawnLocation();
        this.players.clear();
        this.players.addAll(Bukkit.getOnlinePlayers());
        for (Player player : this.players) {
            player.setHealth(20.0);
            player.setSaturation(20.0f);
            player.setFoodLevel(20);
            player.setTotalExperience(0);
            player.setExp(0.0f);
            player.sendExperienceChange(0.0f, 0);
            player.setGameMode(GameMode.SURVIVAL);
            player.teleport(spawnLocation);
            player.setRespawnLocation(spawnLocation);
            player.getInventory().clear();
            player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
            player.sendTitle(this.text.getTitle("start"), null, -1, -1, -1);
            Tracker.trackLocation(player, player.getLocation(), this.text.getItem("compass"));
            this.sb.setGame(this);
            this.sb.newScoreboard(player);
        }
        this.hours = this.durationHours;
        this.min = this.durationMin;
        this.sec = 15;
        this.running = true;
        this.leaderboard = "";
        this.gameLoop = new BukkitRunnable(){

            public void run() {
                Game.this.newGameSecond();
            }
        };
        this.worldManager.startGracePeriod();
        new BukkitRunnable(){

            public void run() {
                Bukkit.broadcastMessage((String)(ChatColor.BLUE + "Scenario: " + Game.this.scenario.getName()));
            }
        }.runTaskLater((Plugin)this.plugin, 120L);
        this.gameLoop.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void stop() {
        Bukkit.getPluginManager().callEvent((Event)new RandomItemChallengeStopEvent(this));
        this.gameLoop.cancel();
        this.players.forEach(player -> player.getScoreboard().clearSlot(DisplaySlot.SIDEBAR));
        this.players.clear();
        this.spectators.forEach(player -> player.getScoreboard().clearSlot(DisplaySlot.SIDEBAR));
        this.spectators.clear();
        this.running = false;
        Bukkit.broadcastMessage((String)this.text.getBroadcast("end").replace("$TIME", this.getTimeSinceStart()));
        Bukkit.broadcastMessage((String)(ChatColor.BLUE + String.valueOf(ChatColor.UNDERLINE) + "Leaderboard :" + this.leaderboard + ChatColor.RESET));
        new BukkitRunnable(){

            public void run() {
                Game.this.worldManager.loadNextLocation();
            }
        }.runTaskLater((Plugin)this.plugin, 5L);
    }

    private void newGameSecond() {
        Bukkit.getPluginManager().callEvent((Event)new RandomItemChallengeUpdateEvent(this));
        --this.sec;
        if (this.sec < 0) {
            if (this.min % this.scenario.getDropInterval() == 0) {
                this.scenario.giveItems(this.players);
            }
            this.sec += 60;
            --this.min;
            if (this.min == -1) {
                this.min += 60;
                --this.hours;
                if (this.hours == -1) {
                    Bukkit.broadcastMessage((String)this.text.getBroadcast("end-by-time"));
                    for (Player player : this.players) {
                        this.leaderboard = "\n%s#1) %s: Still alive%s".formatted(ChatColor.GOLD, player.getName(), this.leaderboard);
                    }
                    this.stop();
                    return;
                }
            }
            if (this.hours == this.durationHours - 1 && this.durationMin == 0 || this.hours == this.durationHours && this.min == this.durationMin - 1) {
                this.worldManager.endGracePeriod();
            }
        }
        for (Player player : this.players) {
            this.sb.updateScoreboard(player);
            double nearestDistance = Double.POSITIVE_INFINITY;
            Player nearestEnemy = player;
            for (Player enemy : this.players) {
                double distance;
                if (enemy == player || !((distance = player.getLocation().distance(enemy.getLocation())) < nearestDistance)) continue;
                nearestDistance = distance;
                nearestEnemy = enemy;
            }
            Tracker.trackLocation(player, nearestEnemy.getLocation(), this.text.getItem("compass"));
        }
        for (Player spectator : this.spectators) {
            this.sb.updateScoreboard(spectator);
        }
    }

    public void playerDeath(Player player) {
        if (this.players.contains(player)) {
            String pos = String.valueOf(this.players.size());
            Bukkit.broadcastMessage((String)this.text.getBroadcast("player-out").replace("$PLAYER", player.getName()).replace("$POS", pos));
            player.sendMessage(this.text.getMessage("time-survived").replace("$TIME", this.getTimeSinceStart()));
            this.leaderboard = "\n" + ChatColor.GREEN + "#$POS) $PLAYER: $TIME".replace("$POS", pos).replace("$PLAYER", player.getName()).replace("$TIME", this.getTimeSinceStart()) + this.leaderboard;
            this.players.remove(player);
            this.spectators.add(player);
            if (this.players.size() == 1) {
                Bukkit.broadcastMessage((String)this.text.getBroadcast("winner").replace("$WINNER", this.players.get(0).getName()));
                this.leaderboard = "\n" + ChatColor.GOLD + "#1) $WINNER: Still alive".replace("$WINNER", this.players.get(0).getName()) + this.leaderboard;
                this.stop();
            } else if (this.players.isEmpty()) {
                Bukkit.broadcastMessage((String)this.text.getBroadcast("playing-alone"));
                this.stop();
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPlayersRemaining() {
        return this.players.size();
    }

    public String getTimeSinceStart() {
        return "$HOURS hours and $MIN minutes.".replace("$HOURS", String.valueOf(this.min == 0 ? 2 - this.hours : 1 - this.hours)).replace("$MIN", String.valueOf(this.min == 0 ? 0 : 60 - this.min));
    }

    public String getTimeRemaining() {
        return this.hours + ":" + (this.min < 10 ? "0" : "") + this.min + ":" + (this.sec < 10 ? "0" : "") + this.sec;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }
}

