/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge.game;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Tracker {
    public static void updateCompass(ItemStack item, Location location) {
        if (item.getType().equals((Object)Material.COMPASS)) {
            CompassMeta meta = (CompassMeta)item.getItemMeta();
            assert (meta != null);
            meta.setLodestone(location);
            meta.setLodestoneTracked(false);
            item.setItemMeta((ItemMeta)meta);
        }
    }

    public static ItemStack getCompass(Location location, String name) {
        ItemStack item = new ItemStack(Material.COMPASS);
        CompassMeta meta = (CompassMeta)item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName(name);
        meta.setLodestone(location);
        meta.setLodestoneTracked(false);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static void trackLocation(Player player, Location location, String name) {
        PlayerInventory inv = player.getInventory();
        if (inv.contains(Material.COMPASS)) {
            ItemStack item = inv.getItem(inv.first(Material.COMPASS));
            assert (item != null);
            Tracker.updateCompass(item, location);
        } else if (inv.getItemInOffHand().getType().equals((Object)Material.COMPASS)) {
            Tracker.updateCompass(inv.getItemInOffHand(), location);
        } else {
            ItemStack item = Tracker.getCompass(location, name);
            if (inv.getItem(8) == null) {
                inv.setItem(8, item);
            } else {
                int firstEmptySlot = inv.firstEmpty();
                if (firstEmptySlot == -1) {
                    player.getWorld().dropItem(player.getLocation(), item);
                } else {
                    inv.setItem(firstEmptySlot, item);
                }
            }
        }
    }
}

