/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge.game.scenario;

import fr.lanfix.randomitemchallenge.RandomItemChallenge;
import fr.lanfix.randomitemchallenge.exceptions.ConfigurationException;
import fr.lanfix.randomitemchallenge.game.scenario.OneListScenario;
import fr.lanfix.randomitemchallenge.game.scenario.RaritiesScenario;
import fr.lanfix.randomitemchallenge.game.scenario.Rarity;
import fr.lanfix.randomitemchallenge.game.scenario.Scenario;
import fr.lanfix.randomitemchallenge.game.scenario.dropchoice.AnyDropChoice;
import fr.lanfix.randomitemchallenge.game.scenario.dropchoice.CustomDropChoice;
import fr.lanfix.randomitemchallenge.game.scenario.dropchoice.DropChoice;
import fr.lanfix.randomitemchallenge.game.scenario.dropchoice.SingleDropChoice;
import fr.lanfix.randomitemchallenge.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class Configuration {
    public static final Map<String, DropChoice> dropChoices = new HashMap<String, DropChoice>();
    public static final Map<String, Scenario> scenarios = new HashMap<String, Scenario>();
    public static Scenario defaultScenario;

    public static void loadScenarios(RandomItemChallenge plugin) {
        scenarios.clear();
        File scenariosFolder = new File(plugin.getDataFolder(), "scenarios");
        String[] scenarioCodes = scenariosFolder.list(FileUtils.endsWithFilenameFilter(".yml"));
        assert (scenarioCodes != null);
        for (String scenarioCode : scenarioCodes) {
            scenarioCode = scenarioCode.replace(".yml", "");
            scenarios.put(scenarioCode, Configuration.loadScenario(plugin, scenarioCode));
        }
        defaultScenario = scenarios.get(plugin.getConfig().getString("default-scenario"));
    }

    private static Scenario loadScenario(RandomItemChallenge plugin, String codeName) {
        File scenarioFile = new File(plugin.getDataFolder(), "scenarios/" + codeName + ".yml");
        YamlConfiguration scenarioConfig = YamlConfiguration.loadConfiguration((File)scenarioFile);
        String name = scenarioConfig.getString("name", "Unnamed Scenario");
        String broadcastMessage = scenarioConfig.getString("item-drop-message", "\u00a7aITEM DROP !!");
        int dropInterval = scenarioConfig.getInt("drop-interval", 2);
        int dropStacks = scenarioConfig.getInt("stacks", 9);
        int dropCount = scenarioConfig.getInt("drop-count", 1);
        switch (scenarioConfig.getString("type", "allItems")) {
            case "list": {
                List<DropChoice> dropChoices = Configuration.loadDropChoices(plugin, scenarioConfig.getStringList("items"), dropStacks);
                return new OneListScenario(name, broadcastMessage, dropInterval, dropCount, dropChoices);
            }
            case "allItems": {
                ArrayList<DropChoice> dropChoices = new ArrayList<DropChoice>();
                for (Material material : Material.values()) {
                    if (!material.isItem()) continue;
                    dropChoices.add(new SingleDropChoice(dropStacks, material));
                }
                return new OneListScenario(name, broadcastMessage, dropInterval, dropCount, dropChoices);
            }
            case "rarities": {
                ConfigurationSection raritiesSection = scenarioConfig.getConfigurationSection("rarities");
                if (raritiesSection == null) {
                    throw new ConfigurationException("Rarities scenario '" + name + "' has no 'rarities' field in its Configuration.");
                }
                List<Rarity> rarities = raritiesSection.getKeys(false).stream().map(rarity -> {
                    String rarityName = raritiesSection.getString(rarity + ".name");
                    double probability = raritiesSection.getDouble(rarity + ".probability");
                    List<DropChoice> dropChoices = Configuration.loadDropChoices(plugin, raritiesSection.getStringList(rarity + ".items"), dropStacks);
                    return new Rarity(probability, dropChoices, dropCount, rarityName);
                }).toList();
                return new RaritiesScenario(name, broadcastMessage, dropInterval, dropCount, rarities);
            }
        }
        throw new IllegalStateException("Wrong scenario type: " + plugin.getConfig().getString("type"));
    }

    public static List<DropChoice> loadDropChoices(RandomItemChallenge plugin, List<String> dropCodes, int dropStacks) {
        ArrayList<DropChoice> dropChoices = new ArrayList<DropChoice>();
        dropCodes.forEach(code -> {
            if ((code = code.toUpperCase()).startsWith("ANY.")) {
                dropChoices.add(Configuration.loadAnyDropChoice(plugin, code, dropStacks));
            } else if (code.startsWith("CUSTOM.")) {
                dropChoices.add(Configuration.loadCustomDropChoice(plugin, code));
            } else {
                dropChoices.add(Configuration.loadSingleDropChoice(code, dropStacks));
            }
        });
        return dropChoices;
    }

    public static DropChoice loadSingleDropChoice(String code, int dropStacks) {
        String fullCode = code + "." + dropStacks;
        if (dropChoices.containsKey(fullCode)) {
            return dropChoices.get(fullCode);
        }
        SingleDropChoice dropChoice = new SingleDropChoice(dropStacks, code);
        dropChoices.put(fullCode, dropChoice);
        return dropChoice;
    }

    public static DropChoice loadAnyDropChoice(RandomItemChallenge plugin, String code, int dropStacks) {
        String fullCode = code + "." + dropStacks;
        if (dropChoices.containsKey(fullCode)) {
            return dropChoices.get(fullCode);
        }
        AnyDropChoice dropChoice = new AnyDropChoice(plugin, code, dropStacks);
        dropChoices.put(fullCode, dropChoice);
        return dropChoice;
    }

    public static DropChoice loadCustomDropChoice(RandomItemChallenge plugin, String code) {
        if (dropChoices.containsKey(code)) {
            return dropChoices.get(code);
        }
        CustomDropChoice dropChoice = new CustomDropChoice(plugin, code);
        dropChoices.put(code, dropChoice);
        return dropChoice;
    }

    public static Scenario getScenarioOrDefault(String codeName) {
        Scenario scenario = scenarios.get(codeName);
        if (scenario == null) {
            scenario = defaultScenario;
        }
        return scenario;
    }

    public static void setDefaultScenario(Scenario defaultScenario) {
        Configuration.defaultScenario = defaultScenario;
    }
}

