/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge.game.scenario;

import fr.lanfix.randomitemchallenge.game.scenario.Rarity;
import fr.lanfix.randomitemchallenge.game.scenario.Scenario;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RaritiesScenario
extends Scenario {
    private final List<Rarity> rarities;

    public RaritiesScenario(String name, String broadcastMessage, int dropInterval, int dropCount, List<Rarity> rarities) {
        super(name, broadcastMessage, dropInterval, dropCount);
        this.rarities = rarities;
    }

    @Override
    public void giveItems(List<Player> players) {
        double randomDouble = ThreadLocalRandom.current().nextDouble();
        Rarity chosenRarity = null;
        for (Rarity rarity : this.rarities) {
            if (randomDouble <= rarity.getProbability()) {
                chosenRarity = rarity;
                break;
            }
            randomDouble -= rarity.getProbability();
        }
        assert (chosenRarity != null);
        Bukkit.broadcastMessage((String)this.broadcastMessage.replace("%rarity%", chosenRarity.getName()));
        for (Player player : players) {
            World world = player.getWorld();
            Location location = player.getLocation();
            List<ItemStack> drops = chosenRarity.getNewDrop();
            this.protectItems(drops, player.getName());
            drops.forEach(item -> world.dropItem(location, item));
        }
    }
}

