/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge.game.scenario;

import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Scenario {
    private final String name;
    final String broadcastMessage;
    final int dropInterval;
    final int dropCount;

    Scenario(String name, String broadcastMessage, int dropInterval, int dropCount) {
        this.name = name;
        this.broadcastMessage = broadcastMessage;
        this.dropInterval = dropInterval;
        this.dropCount = dropCount;
    }

    protected List<ItemStack> getNewDrop() {
        return List.of();
    }

    public void giveItems(List<Player> players) {
        Bukkit.broadcastMessage((String)this.broadcastMessage);
        for (Player player : players) {
            World world = player.getWorld();
            Location location = player.getLocation();
            List<ItemStack> drops = this.getNewDrop();
            this.protectItems(drops, player.getName());
            drops.forEach(item -> world.dropItem(location, item));
        }
    }

    protected void protectItems(List<ItemStack> items, String playerName) {
        items.forEach(item -> this.protectItem((ItemStack)item, playerName));
    }

    private void protectItem(ItemStack item, String playerName) {
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        itemMeta.setLore(Collections.singletonList(playerName));
        item.setItemMeta(itemMeta);
    }

    public String getName() {
        return this.name;
    }

    public int getDropInterval() {
        return this.dropInterval;
    }
}

