/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge.game.scenario.dropchoice;

import fr.lanfix.randomitemchallenge.RandomItemChallenge;
import fr.lanfix.randomitemchallenge.game.scenario.dropchoice.DropChoice;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class AnyDropChoice
extends DropChoice {
    private final int dropStacks;
    private final List<Material> materials;

    public AnyDropChoice(RandomItemChallenge plugin, String code, int dropStacks) {
        this.dropStacks = dropStacks;
        File dropFile = new File(plugin.getDataFolder(), "custom_drops/" + code.toLowerCase().replace(".", "/") + ".yml");
        YamlConfiguration dropConfig = YamlConfiguration.loadConfiguration((File)dropFile);
        this.materials = dropConfig.getStringList("items").stream().map(material -> Material.valueOf((String)material.toUpperCase())).toList();
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Material material = this.materials.get(ThreadLocalRandom.current().nextInt(this.materials.size()));
        ItemStack item = new ItemStack(material, material.getMaxStackSize());
        for (int j = 0; j < this.dropStacks; ++j) {
            drops.add(item);
        }
        return drops;
    }
}

