/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge.game.scenario.dropchoice;

import fr.lanfix.randomitemchallenge.RandomItemChallenge;
import fr.lanfix.randomitemchallenge.game.scenario.dropchoice.DropChoice;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomDropChoice
extends DropChoice {
    private final List<ItemStack> drops = new ArrayList<ItemStack>();

    public CustomDropChoice(RandomItemChallenge plugin, String code) {
        File dropFile = new File(plugin.getDataFolder(), "custom_drops/" + code.toLowerCase().replace(".", "/") + ".yml");
        YamlConfiguration dropConfig = YamlConfiguration.loadConfiguration((File)dropFile);
        dropConfig.getMapList("items").forEach(map -> {
            Material material = Material.valueOf((String)((String)map.get("material")).toUpperCase());
            int stacks = map.containsKey("stacks") ? (Integer)map.get("stacks") : 1;
            ItemStack itemStack = new ItemStack(material, material.getMaxStackSize());
            ItemMeta itemMeta = itemStack.getItemMeta();
            assert (itemMeta != null);
            if (map.containsKey("name")) {
                itemMeta.setDisplayName((String)map.get("name"));
            }
            if (map.containsKey("lore")) {
                itemMeta.setLore((List)map.get("lore"));
            }
            if (map.containsKey("enchantments")) {
                Map enchantments = (Map)map.get("enchantments");
                enchantments.forEach((enchantmentName, level) -> {
                    Enchantment enchantment = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)enchantmentName));
                    if (enchantment == null) {
                        return;
                    }
                    itemStack.addUnsafeEnchantment(enchantment, level.intValue());
                });
            }
            if (material.equals((Object)Material.FIREWORK_ROCKET) && map.containsKey("explosive_rockets") && ((Boolean)map.get("explosive_rockets")).booleanValue()) {
                ((FireworkMeta)itemMeta).addEffect(FireworkEffect.builder().with(FireworkEffect.Type.STAR).withColor(new Color[]{Color.ORANGE, Color.RED, Color.YELLOW}).build());
            }
            itemStack.setItemMeta(itemMeta);
            for (int i = 0; i < stacks; ++i) {
                this.drops.add(itemStack);
            }
        });
    }

    @Override
    public List<ItemStack> getDrops() {
        return this.drops;
    }
}

