/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.randomitemchallenge.world;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.event.world.WorldEvent;
import org.popcraft.chunky.api.ChunkyAPI;

public class WorldManager {
    private static WorldManager worldManager;
    private final List<String> biomesBlacklist;
    private final World world;
    private Location nextLocation;

    private WorldManager(List<String> biomesBlacklist, int border, boolean useSeparateWorld) {
        World world;
        this.biomesBlacklist = biomesBlacklist;
        World world2 = world = useSeparateWorld ? Bukkit.getWorld((String)"RandomItemChallenge_world") : Bukkit.getWorld((String)"world");
        if (world == null) {
            world = this.createWorld();
        }
        world.getWorldBorder().setSize((double)border);
        world.setTime(0L);
        world.setDifficulty(Difficulty.HARD);
        world.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
        world.setGameRule(GameRule.DO_ENTITY_DROPS, (Object)false);
        world.setGameRule(GameRule.DO_MOB_LOOT, (Object)false);
        world.setGameRule(GameRule.DO_TILE_DROPS, (Object)false);
        this.world = world;
        this.loadNextLocation();
    }

    public static void createWorldManager(List<String> biomesBlacklist, int border, boolean useSeparateWorld) {
        worldManager = new WorldManager(biomesBlacklist, border, useSeparateWorld);
    }

    public static WorldManager getWorldManager() {
        if (worldManager == null) {
            worldManager = new WorldManager(new ArrayList<String>(), 500, true);
        }
        return worldManager;
    }

    private World createWorld() {
        WorldCreator worldCreator = new WorldCreator("RandomItemChallenge_world");
        return worldCreator.createWorld();
    }

    public Location getSpawnLocation() {
        Location spawnLocation = this.nextLocation;
        this.world.getWorldBorder().setCenter(spawnLocation.getX(), spawnLocation.getZ());
        this.world.setSpawnLocation(spawnLocation);
        int x = spawnLocation.getBlockX();
        int z = spawnLocation.getBlockZ();
        this.world.setBlockData(x, -64, z, this.world.getBlockData(x, -50, z));
        return spawnLocation;
    }

    public void loadNextLocation() {
        int tries = 1;
        boolean found = false;
        int x = 0;
        int z = 0;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (!found) {
            if (this.world.getBlockAt(x, -64, z).getType().equals((Object)Material.BEDROCK) && !this.biomesBlacklist.contains(this.world.getBiome(x, 63, z).toString())) {
                found = true;
                continue;
            }
            x = random.nextInt(tries * -5, tries * 5 + 1) * 3000;
            z = random.nextInt(tries * -5, tries * 5 + 1) * 3000;
            ++tries;
        }
        Bukkit.getLogger().log(Level.INFO, "Found next starting location in %TRIES tries.".replace("%TRIES", String.valueOf(tries)));
        this.nextLocation = this.getSpawnHeight(x, z);
        this.preloadNextLocation();
    }

    private void preloadNextLocation() {
        if (Bukkit.getPluginManager().isPluginEnabled("Chunky")) {
            ChunkyAPI api = (ChunkyAPI)Bukkit.getServicesManager().load(ChunkyAPI.class);
            if (api == null) {
                return;
            }
            boolean hasStarted = api.startTask(this.world.getName(), "square", this.nextLocation.getX(), this.nextLocation.getZ(), 20.0, 20.0, "concentric");
            if (hasStarted) {
                Bukkit.getLogger().info("Next Random Item Challenge game area started pre-generating its chunks.");
            }
            api.onGenerationComplete(generationCompleteEvent -> {
                if (generationCompleteEvent.world().equals(this.world.getName())) {
                    Bukkit.getLogger().info("Next Random Item Challenge area pre-generated successfully !");
                }
            });
        } else {
            Bukkit.getLogger().info("Chunky plugin for area preloading is not present on the server, consequently there will be some lag...\nI suggest to install the plugin Chunky for a better experience");
        }
    }

    public void startGracePeriod() {
        this.world.setGameRule(GameRule.FALL_DAMAGE, (Object)false);
        this.world.setPVP(false);
        this.world.setTime(0L);
    }

    public void endGracePeriod() {
        this.world.setGameRule(GameRule.FALL_DAMAGE, (Object)true);
        this.world.setPVP(true);
        this.world.setTime(0L);
    }

    private Location getSpawnHeight(int x, int z) {
        int y = this.world.getMaxHeight() - 1;
        while (this.world.getBlockData(x, y, z).getMaterial().equals((Object)Material.AIR)) {
            --y;
        }
        return new Location(this.world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5);
    }

    public boolean isEventInGameWorld(WorldEvent event) {
        return event.getWorld() == this.world;
    }
}

