/*
 * Decompiled with CFR 0.152.
 */
package com.treeminer;

import com.treeminer.TreeMinerCommand;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TreeMiner
extends JavaPlugin
implements Listener {
    private boolean requirePermission;
    private boolean requireSneaking;
    private boolean requireAxe;
    private boolean durabilityLoss;
    private int maxLogs;
    private Set<Material> validMaterials;
    private Set<UUID> enabledPlayers;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.enabledPlayers = new HashSet<UUID>();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("treeminer").setExecutor(new TreeMinerCommand(this));
        this.getLogger().info("TreeMiner has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("TreeMiner has been disabled!");
    }

    public void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.requirePermission = config.getBoolean("require-permission", true);
        this.requireSneaking = config.getBoolean("require-sneaking", true);
        this.requireAxe = config.getBoolean("require-axe", true);
        this.durabilityLoss = config.getBoolean("durability-loss", true);
        this.maxLogs = config.getInt("max-logs", 100);
        this.validMaterials = new HashSet<Material>();
        for (String material : config.getStringList("valid-materials")) {
            try {
                this.validMaterials.add(Material.valueOf(material.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid material in config: " + material);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        final Player player = event.getPlayer();
        final Block block = event.getBlock();
        if (!this.enabledPlayers.contains(player.getUniqueId())) {
            return;
        }
        if (!this.isLog(block.getType())) {
            return;
        }
        if (this.requirePermission && !player.hasPermission("treeminer.use")) {
            return;
        }
        if (this.requireSneaking && !player.isSneaking()) {
            return;
        }
        final ItemStack tool = player.getInventory().getItemInMainHand();
        if (this.requireAxe && !this.isAxe(tool.getType())) {
            return;
        }
        event.setCancelled(true);
        new BukkitRunnable(this){
            final /* synthetic */ TreeMiner this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.breakTree(player, block, tool);
            }
        }.runTask(this);
    }

    private void breakTree(Player player, Block startBlock, ItemStack tool) {
        HashSet<Block> blocksToBreak = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        queue.add(startBlock);
        while (!queue.isEmpty() && blocksToBreak.size() < this.maxLogs) {
            Block current = (Block)queue.poll();
            if (blocksToBreak.contains(current) || !this.isLog(current.getType())) continue;
            blocksToBreak.add(current);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Block adjacent = current.getRelative(x, y, z);
                        if (!this.isLog(adjacent.getType()) || blocksToBreak.contains(adjacent)) continue;
                        queue.add(adjacent);
                    }
                }
            }
        }
        int damage = 0;
        for (Block block : blocksToBreak) {
            Material type = block.getType();
            Collection<ItemStack> drops = block.getDrops(tool);
            block.setType(Material.AIR);
            for (ItemStack drop : drops) {
                player.getWorld().dropItemNaturally(block.getLocation(), drop);
            }
            ++damage;
        }
        if (this.durabilityLoss && tool.getType().getMaxDurability() > 0) {
            short durability = tool.getDurability();
            short newDurability = (short)(durability + Math.min(damage, tool.getType().getMaxDurability() - durability));
            if (newDurability >= tool.getType().getMaxDurability()) {
                player.getInventory().setItemInMainHand(null);
            } else {
                tool.setDurability(newDurability);
            }
        }
    }

    private boolean isLog(Material material) {
        return this.validMaterials.contains(material);
    }

    private boolean isAxe(Material material) {
        return material.name().endsWith("_AXE");
    }

    public Set<UUID> getEnabledPlayers() {
        return this.enabledPlayers;
    }
}

