/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieNautilus;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.loot.LootTables;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Registry<T extends Keyed>
extends Iterable<T> {
    @Deprecated(since="1.21.4")
    public static final Registry<Advancement> ADVANCEMENT = new Registry<Advancement>(){

        @Override
        @Nullable
        public Advancement get(@NotNull NamespacedKey key) {
            return Bukkit.getAdvancement(key);
        }

        @Override
        @NotNull
        public Advancement getOrThrow(@NotNull NamespacedKey key) {
            Advancement advancement = this.get(key);
            Preconditions.checkArgument(advancement != null, "No Advancement registry entry found for key %s.", (Object)key);
            return advancement;
        }

        @Override
        @NotNull
        public Stream<Advancement> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        @NotNull
        public Iterator<Advancement> iterator() {
            return Bukkit.advancementIterator();
        }
    };
    public static final Registry<Art> ART = Objects.requireNonNull(Bukkit.getRegistry(Art.class), "No registry present for Art. This is a bug.");
    public static final Registry<Attribute> ATTRIBUTE = Objects.requireNonNull(Bukkit.getRegistry(Attribute.class), "No registry present for Attribute. This is a bug.");
    public static final Registry<PatternType> BANNER_PATTERN = Objects.requireNonNull(Bukkit.getRegistry(PatternType.class), "No registry present for Pattern Type. This is a bug.");
    public static final Registry<Biome> BIOME = Objects.requireNonNull(Bukkit.getRegistry(Biome.class), "No registry present for Biome. This is a bug.");
    @ApiStatus.Internal
    public static final Registry<BlockType> BLOCK = Objects.requireNonNull(Bukkit.getRegistry(BlockType.class), "No registry present for BlockType. This is a bug.");
    @Deprecated(since="1.21.4")
    public static final Registry<KeyedBossBar> BOSS_BARS = new Registry<KeyedBossBar>(){

        @Override
        @Nullable
        public KeyedBossBar get(@NotNull NamespacedKey key) {
            return Bukkit.getBossBar(key);
        }

        @Override
        @NotNull
        public KeyedBossBar getOrThrow(@NotNull NamespacedKey key) {
            KeyedBossBar keyedBossBar = this.get(key);
            Preconditions.checkArgument(keyedBossBar != null, "No KeyedBossBar registry entry found for key %s.", (Object)key);
            return keyedBossBar;
        }

        @Override
        @NotNull
        public Stream<KeyedBossBar> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        @NotNull
        public Iterator<KeyedBossBar> iterator() {
            return Bukkit.getBossBars();
        }
    };
    public static final Registry<Cat.Type> CAT_VARIANT = Objects.requireNonNull(Bukkit.getRegistry(Cat.Type.class), "No registry present for Cat Type. This is a bug.");
    public static final Registry<Pig.Variant> PIG_VARIANT = Objects.requireNonNull(Bukkit.getRegistry(Pig.Variant.class), "No registry present for Pig Variant. This is a bug.");
    public static final Registry<Cow.Variant> COW_VARIANT = Objects.requireNonNull(Bukkit.getRegistry(Cow.Variant.class), "No registry present for Cow Variant. This is a bug.");
    public static final Registry<Chicken.Variant> CHICKEN_VARIANT = Objects.requireNonNull(Bukkit.getRegistry(Chicken.Variant.class), "No registry present for Chicken Variant. This is a bug.");
    public static final Registry<ZombieNautilus.Variant> ZOMBIE_NAUTILUS_VARIANT = Objects.requireNonNull(Bukkit.getRegistry(ZombieNautilus.Variant.class), "No registry present for ZombieNautilus Variant. This is a bug.");
    public static final Registry<Enchantment> ENCHANTMENT = Objects.requireNonNull(Bukkit.getRegistry(Enchantment.class), "No registry present for Enchantment. This is a bug.");
    public static final Registry<EntityType> ENTITY_TYPE = new SimpleRegistry<EntityType>(EntityType.class, entity -> entity != EntityType.UNKNOWN);
    public static final Registry<MusicInstrument> INSTRUMENT = Objects.requireNonNull(Bukkit.getRegistry(MusicInstrument.class), "No registry present for MusicInstrument. This is a bug.");
    @ApiStatus.Internal
    public static final Registry<ItemType> ITEM = Objects.requireNonNull(Bukkit.getRegistry(ItemType.class), "No registry present for ItemType. This is a bug.");
    @Deprecated(since="1.21.4")
    public static final Registry<LootTables> LOOT_TABLES = new SimpleRegistry<LootTables>(LootTables.class);
    public static final Registry<Material> MATERIAL = new SimpleRegistry<Material>(Material.class, mat -> !mat.isLegacy());
    @ApiStatus.Experimental
    public static final Registry<MenuType> MENU = Objects.requireNonNull(Bukkit.getRegistry(MenuType.class), "No registry present for MenuType. This is a bug.");
    public static final Registry<PotionEffectType> EFFECT = Objects.requireNonNull(Bukkit.getRegistry(PotionEffectType.class), "No registry present for PotionEffectType. This is a bug.");
    public static final Registry<Particle> PARTICLE_TYPE = new SimpleRegistry<Particle>(Particle.class, par -> par.register);
    public static final Registry<PotionType> POTION = new SimpleRegistry<PotionType>(PotionType.class);
    public static final Registry<Statistic> STATISTIC = new SimpleRegistry<Statistic>(Statistic.class);
    public static final Registry<Structure> STRUCTURE = Objects.requireNonNull(Bukkit.getRegistry(Structure.class), "No registry present for Structure. This is a bug.");
    public static final Registry<StructureType> STRUCTURE_TYPE = Objects.requireNonNull(Bukkit.getRegistry(StructureType.class), "No registry present for StructureType. This is a bug.");
    public static final Registry<Sound> SOUNDS = Objects.requireNonNull(Bukkit.getRegistry(Sound.class), "No registry present for Sound. This is a bug.");
    @ApiStatus.Experimental
    public static final Registry<TrimMaterial> TRIM_MATERIAL = Objects.requireNonNull(Bukkit.getRegistry(TrimMaterial.class), "No registry present for TrimMaterial. This is a bug.");
    @ApiStatus.Experimental
    public static final Registry<TrimPattern> TRIM_PATTERN = Objects.requireNonNull(Bukkit.getRegistry(TrimPattern.class), "No registry present for TrimPattern. This is a bug.");
    @ApiStatus.Experimental
    public static final Registry<DamageType> DAMAGE_TYPE = Objects.requireNonNull(Bukkit.getRegistry(DamageType.class), "No registry present for DamageType. This is a bug.");
    @ApiStatus.Experimental
    public static final Registry<JukeboxSong> JUKEBOX_SONG = Objects.requireNonNull(Bukkit.getRegistry(JukeboxSong.class), "No registry present for JukeboxSong. This is a bug.");
    public static final Registry<Villager.Profession> VILLAGER_PROFESSION = Objects.requireNonNull(Bukkit.getRegistry(Villager.Profession.class), "No registry present for Villager Profession. This is a bug.");
    public static final Registry<Villager.Type> VILLAGER_TYPE = Objects.requireNonNull(Bukkit.getRegistry(Villager.Type.class), "No registry present for Villager Type. This is a bug.");
    public static final Registry<GameRule> GAME_RULE = Objects.requireNonNull(Bukkit.getRegistry(GameRule.class), "No registry present for Game Rule. This is a bug.");
    public static final Registry<MemoryKey> MEMORY_MODULE_TYPE = new Registry<MemoryKey>(){

        @Override
        @NotNull
        public Iterator iterator() {
            return MemoryKey.values().iterator();
        }

        @Override
        @Nullable
        public MemoryKey get(@NotNull NamespacedKey key) {
            return MemoryKey.getByKey(key);
        }

        @Override
        @NotNull
        public MemoryKey getOrThrow(@NotNull NamespacedKey key) {
            MemoryKey memoryKey = this.get(key);
            Preconditions.checkArgument(memoryKey != null, "No MemoryKey registry entry found for key %s.", (Object)key);
            return memoryKey;
        }

        @Override
        @NotNull
        public Stream<MemoryKey> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    };
    public static final Registry<Fluid> FLUID = Objects.requireNonNull(Bukkit.getRegistry(Fluid.class), "No registry present for Fluid. This is a bug.");
    public static final Registry<Frog.Variant> FROG_VARIANT = Objects.requireNonNull(Bukkit.getRegistry(Frog.Variant.class), "No registry present for Frog Variant. This is a bug.");
    public static final Registry<Wolf.Variant> WOLF_VARIANT = Objects.requireNonNull(Bukkit.getRegistry(Wolf.Variant.class), "No registry present for Wolf Variant. This is a bug.");
    public static final Registry<MapCursor.Type> MAP_DECORATION_TYPE = Objects.requireNonNull(Bukkit.getRegistry(MapCursor.Type.class), "No registry present for MapCursor Type. This is a bug.");
    public static final Registry<GameEvent> GAME_EVENT = Objects.requireNonNull(Bukkit.getRegistry(GameEvent.class), "No registry present for GameEvent. This is a bug.");

    @Nullable
    public T get(@NotNull NamespacedKey var1);

    @NotNull
    public T getOrThrow(@NotNull NamespacedKey var1);

    @NotNull
    public Stream<T> stream();

    @Nullable
    default public T match(@NotNull String input) {
        Preconditions.checkArgument(input != null, "input must not be null");
        String filtered = input.toLowerCase(Locale.ROOT).replaceAll("\\s+", "_");
        NamespacedKey namespacedKey = NamespacedKey.fromString(filtered);
        return namespacedKey != null ? (T)this.get(namespacedKey) : null;
    }

    public static final class SimpleRegistry<T extends Enum<T>>
    implements Registry<T> {
        private final Class<T> type;
        private final Map<NamespacedKey, T> map;

        protected SimpleRegistry(@NotNull Class<T> type) {
            this(type, Predicates.alwaysTrue());
        }

        protected SimpleRegistry(@NotNull Class<T> type, @NotNull Predicate<T> predicate) {
            ImmutableMap.Builder<NamespacedKey, Enum> builder = ImmutableMap.builder();
            for (Enum entry : (Enum[])type.getEnumConstants()) {
                if (!predicate.test(entry)) continue;
                builder.put(((Keyed)((Object)entry)).getKey(), entry);
            }
            this.map = builder.build();
            this.type = type;
        }

        @Override
        @Nullable
        public T get(@NotNull NamespacedKey key) {
            return (T)((Enum)this.map.get(key));
        }

        @Override
        @NotNull
        public T getOrThrow(@NotNull NamespacedKey key) {
            T object = this.get(key);
            Preconditions.checkArgument(object != null, "No %s registry entry found for key %s.", this.type, (Object)key);
            return object;
        }

        @Override
        @NotNull
        public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.map.values().iterator();
        }

        @Deprecated(since="1.20.6", forRemoval=true)
        @ApiStatus.Internal
        public Class<T> getType() {
            return this.type;
        }
    }
}

