/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.permissions;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PermissionDefault {
    TRUE("true"),
    FALSE("false"),
    OP("op", "isop", "operator", "isoperator", "admin", "isadmin"),
    NOT_OP("!op", "notop", "!operator", "notoperator", "!admin", "notadmin");

    private final String[] names;
    private static final Map<String, PermissionDefault> lookup;

    private PermissionDefault(String ... names) {
        this.names = names;
    }

    public boolean getValue(boolean op) {
        switch (this.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return op;
            }
            case 3: {
                return !op;
            }
        }
        return false;
    }

    @Nullable
    public static PermissionDefault getByName(@NotNull String name) {
        return lookup.get(name.toLowerCase(Locale.ROOT).replaceAll("[^a-z!]", ""));
    }

    public String toString() {
        return this.names[0];
    }

    static {
        lookup = new HashMap<String, PermissionDefault>();
        for (PermissionDefault value : PermissionDefault.values()) {
            for (String name : value.names) {
                lookup.put(name, value);
            }
        }
    }
}

