/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage;

import com.mojang.logging.LogUtils;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import edivad.extrastorage.autocrafting.advancedautocrafter.CrafterTier;
import edivad.extrastorage.compat.top.TOPIntegration;
import edivad.extrastorage.data.ExtraStorageBlockTagsProvider;
import edivad.extrastorage.data.ExtraStorageItemTagsProvider;
import edivad.extrastorage.data.ExtraStorageLanguageProvider;
import edivad.extrastorage.data.ExtraStorageRecipeProvider;
import edivad.extrastorage.data.loot.pack.ExtraStorageLootTableProvider;
import edivad.extrastorage.data.models.ExtraStorageBlockModelProvider;
import edivad.extrastorage.data.models.ExtraStorageItemModelProvider;
import edivad.extrastorage.network.PacketHandler;
import edivad.extrastorage.setup.ClientSetup;
import edivad.extrastorage.setup.Config;
import edivad.extrastorage.setup.CreativeModeTabs;
import edivad.extrastorage.setup.ESBlockEntities;
import edivad.extrastorage.setup.ESBlocks;
import edivad.extrastorage.setup.ESContainer;
import edivad.extrastorage.setup.ESItems;
import edivad.extrastorage.setup.ESLootFunctions;
import edivad.extrastorage.storage.AdvancedFluidStorageVariant;
import edivad.extrastorage.storage.AdvancedItemStorageVariant;
import edivad.extrastorage.tools.UpgradeDestinations;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="extrastorage")
public class ExtraStorage {
    public static final String ID = "extrastorage";
    public static final String MODNAME = "ExtraStorage";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ExtraStorage(ModContainer modContainer, Dist dist) {
        IEventBus modEventBus = modContainer.getEventBus();
        PacketHandler.register(modEventBus);
        ESBlocks.register(modEventBus);
        ESItems.register(modEventBus);
        ESBlockEntities.register(modEventBus);
        ESContainer.register(modEventBus);
        CreativeModeTabs.register(modEventBus);
        Config.registerConfig(modContainer);
        if (dist.isClient()) {
            modEventBus.addListener(ClientSetup::handleClientSetup);
            modEventBus.addListener(ClientSetup::handleRegisterMenuScreens);
        }
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleGatherData);
        modEventBus.addListener(this::onRegister);
        modEventBus.addListener(this::registerCapabilities);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    private void onRegister(RegisterEvent e) {
        e.register(Registries.LOOT_FUNCTION_TYPE, helper -> ESLootFunctions.register());
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ExtraStorageBlockTagsProvider blockTags = new ExtraStorageBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        CompletableFuture blockTagsLookup = blockTags.contentsGetter();
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ExtraStorageItemTagsProvider(packOutput, lookupProvider, blockTagsLookup, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtraStorageLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtraStorageRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtraStorageLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraStorageBlockModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraStorageItemModelProvider(packOutput, existingFileHelper));
    }

    public void handleCommonSetup(FMLCommonSetupEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPIntegration::new);
        }
        if (ModList.get().isLoaded("inventorysorter")) {
            ESContainer.CRAFTER.values().forEach(v -> InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ((DeferredHolder)v).getId()));
            ESContainer.ITEM_STORAGE.values().forEach(v -> InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ((DeferredHolder)v).getId()));
            ESContainer.FLUID_STORAGE.values().forEach(v -> InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ((DeferredHolder)v).getId()));
            InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ESContainer.ADVANCED_EXPORTER.getId());
            InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ESContainer.ADVANCED_IMPORTER.getId());
        }
        this.registerUpgradeMappings();
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        this.registerNetworkNodeContainerProvider(event, (BlockEntityType)ESBlockEntities.ADVANCED_EXPORTER.get());
        this.registerNetworkNodeContainerProvider(event, (BlockEntityType)ESBlockEntities.ADVANCED_IMPORTER.get());
        Arrays.stream(AdvancedItemStorageVariant.values()).forEach(type -> this.registerNetworkNodeContainerProvider(event, (BlockEntityType)ESBlockEntities.ITEM_STORAGE.get(type).get()));
        Arrays.stream(AdvancedFluidStorageVariant.values()).forEach(type -> this.registerNetworkNodeContainerProvider(event, (BlockEntityType)ESBlockEntities.FLUID_STORAGE.get(type).get()));
        Arrays.stream(CrafterTier.values()).forEach(type -> this.registerNetworkNodeContainerProvider(event, (BlockEntityType)ESBlockEntities.CRAFTER.get(type).get()));
    }

    private void registerNetworkNodeContainerProvider(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractNetworkNodeContainerBlockEntity<?>> type) {
        event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), type, (be, side) -> be.getContainerProvider());
    }

    private void registerUpgradeMappings() {
        RefinedStorageApi.INSTANCE.getUpgradeRegistry().forDestination((UpgradeDestination)UpgradeDestinations.ADVANCED_IMPORTER).add((Item)Items.INSTANCE.getSpeedUpgrade(), 4).add((Item)Items.INSTANCE.getStackUpgrade()).add((Item)Items.INSTANCE.getRegulatorUpgrade(), 4);
        RefinedStorageApi.INSTANCE.getUpgradeRegistry().forDestination((UpgradeDestination)UpgradeDestinations.ADVANCED_EXPORTER).add((Item)Items.INSTANCE.getSpeedUpgrade(), 4).add((Item)Items.INSTANCE.getStackUpgrade()).add((Item)Items.INSTANCE.getRegulatorUpgrade(), 4).add((Item)Items.INSTANCE.getAutocraftingUpgrade());
        RefinedStorageApi.INSTANCE.getUpgradeRegistry().forDestination((UpgradeDestination)UpgradeDestinations.ADVANCED_AUTOCRAFTER).add((Item)Items.INSTANCE.getSpeedUpgrade(), 4);
    }
}

