/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.advancedimporter;

import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalCableBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.DirectionalCableBlockShapes;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import edivad.extrastorage.advancedimporter.AdvancedImporterBlockEntity;
import edivad.extrastorage.setup.ESBlockEntities;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AdvancedImporterBlock
extends AbstractDirectionalCableBlock
implements EntityBlock,
BlockItemProvider<BaseBlockItem> {
    private static final Component HELP = IdentifierUtil.createTranslation((String)"item", (String)"importer.help");
    private static final ConcurrentHashMap<AbstractDirectionalCableBlock.DirectionalCacheShapeCacheKey, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap();
    private static final AbstractBlockEntityTicker<AdvancedImporterBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(ESBlockEntities.ADVANCED_IMPORTER);

    public AdvancedImporterBlock() {
        super(SHAPE_CACHE);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AdvancedImporterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return TICKER.get(level, type);
    }

    protected VoxelShape getExtensionShape(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> DirectionalCableBlockShapes.IMPORTER_NORTH;
            case Direction.EAST -> DirectionalCableBlockShapes.IMPORTER_EAST;
            case Direction.SOUTH -> DirectionalCableBlockShapes.IMPORTER_SOUTH;
            case Direction.WEST -> DirectionalCableBlockShapes.IMPORTER_WEST;
            case Direction.UP -> DirectionalCableBlockShapes.IMPORTER_UP;
            case Direction.DOWN -> DirectionalCableBlockShapes.IMPORTER_DOWN;
        };
    }

    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem((Block)this, HELP);
    }
}

