/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kicker.network;

import java.util.function.Supplier;
import net.mcreator.kicker.KickerMod;
import net.mcreator.kicker.procedures.KickOnKeyPressedProcedure;
import net.mcreator.kicker.procedures.KickOnKeyReleasedProcedure;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class KickMessage {
    int type;
    int pressedms;

    public KickMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public KickMessage(PacketBuffer buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(KickMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(KickMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> KickMessage.pressAction((PlayerEntity)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(PlayerEntity entity, int type, int pressedms) {
        World world = entity.field_70170_p;
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        if (!world.func_175667_e(entity.func_180425_c())) {
            return;
        }
        if (type == 0) {
            KickOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            KickOnKeyReleasedProcedure.execute((IWorld)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        KickerMod.addNetworkMessage(KickMessage.class, KickMessage::buffer, KickMessage::new, KickMessage::handler);
    }
}

