/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.create.events;

import com.simibubi.create.api.effect.OpenPipeEffectHandler;
import com.simibubi.create.api.registry.SimpleRegistry;
import dev.latvian.mods.kubejs.create.core.mixin.FluidIngredientStacksInvoker;
import dev.latvian.mods.kubejs.event.KubeEvent;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public class SpecialFluidHandlerEvent
implements KubeEvent {
    public void add(FluidIngredient fluidIngredient, PipeHandler handler) {
        OpenPipeEffectHandler.REGISTRY.registerProvider(SpecialFluidHandlerEvent.createEffectHandler(fluidIngredient, handler));
    }

    static SimpleRegistry.Provider<Fluid, OpenPipeEffectHandler> createEffectHandler(final FluidIngredient fluidIngredient, final PipeHandler handler) {
        return new SimpleRegistry.Provider<Fluid, OpenPipeEffectHandler>(){
            Set<Fluid> validFluids = null;
            final OpenPipeEffectHandler internalHandler = (level, aabb, fluid) -> {
                if (fluidIngredient.test(fluid)) {
                    handler.apply(level, aabb, fluid);
                }
            };

            @Nullable
            public OpenPipeEffectHandler get(Fluid fluidIn) {
                if (this.getValidFluids().contains(fluidIn)) {
                    return this.internalHandler;
                }
                return null;
            }

            private Set<Fluid> getValidFluids() {
                if (this.validFluids == null) {
                    Stream<FluidStack> stacks = ((FluidIngredientStacksInvoker)fluidIngredient).callGenerateStacks();
                    this.validFluids = stacks.map(FluidStack::getFluid).collect(Collectors.toSet());
                }
                return this.validFluids;
            }

            public void onRegister(Runnable invalidate) {
                NeoForge.EVENT_BUS.addListener(event -> {
                    if (event.shouldUpdateStaticData()) {
                        invalidate.run();
                        this.validFluids = null;
                    }
                });
            }
        };
    }

    public static interface PipeHandler {
        public void apply(Level var1, AABB var2, FluidStack var3);
    }
}

