/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.SettingsManager;
import com.choculaterie.gui.ToastManager;
import com.choculaterie.models.SchematicCreateDTO;
import com.choculaterie.networking.LitematicHttpClient;
import com.google.gson.JsonObject;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class PublishScreen
extends class_437 {
    private final class_437 parentScreen;
    private final File litematicFile;
    private class_342 nameField;
    private MultilineTextFieldWidget descriptionField;
    private class_342 tagsField;
    private class_342 youtubeField;
    private class_342 mediaFireField;
    private class_4185 publishButton;
    private final List<File> selectedImages = new ArrayList<File>();
    private final List<File> selectedLitematicFiles = new ArrayList<File>();
    private boolean isPublishing = false;
    private int selectedCoverImageIndex = 0;
    private final Map<File, class_2960> imageTextures = new HashMap<File, class_2960>();
    private final List<File> failedImages = new ArrayList<File>();
    private final Set<String> tagBadges = new LinkedHashSet<String>();
    private String currentNameFieldText = "";
    private String currentDescriptionFieldText = "";
    private String currentTagsFieldText = "";
    private String currentYoutubeFieldText = "";
    private String currentMediaFireFieldText = "";
    private String focusedFieldType = "";
    private int focusedFieldCursorPosition = 0;
    private int scrollOffset = 0;
    private int scrollAreaX;
    private int scrollAreaY;
    private int scrollAreaWidth;
    private int scrollAreaHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarHeight;
    private int totalContentHeight;
    private boolean isScrolling = false;
    private int lastMouseY;
    private static final int MAX_NAME_LENGTH = 50;
    private static final int MAX_DESCRIPTION_LENGTH = 2000;
    private static final int MAX_TAGS = 5;
    private static final int MAX_IMAGES = 5;
    private static final int MAX_LITEMATIC_FILES = 5;
    private static final Pattern URL_PATTERN = Pattern.compile("^https://.*");
    private String youtubeUrlError = "";
    private String mediaFireUrlError = "";
    private String tagError = "";

    public PublishScreen(class_437 parentScreen, File litematicFile) {
        super((class_2561)class_2561.method_43470((String)"Publish Schematic"));
        this.parentScreen = parentScreen;
        this.litematicFile = litematicFile;
        this.selectedLitematicFiles.add(litematicFile);
    }

    protected void method_25426() {
        int baseY;
        this.updateScrollbarDimensions();
        this.saveCurrentTextFieldValues();
        this.method_37067();
        int centerX = this.field_22789 / 2;
        int currentY = baseY = this.scrollAreaY - this.scrollOffset;
        int fieldWidth = 400;
        int fieldHeight = 20;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), button -> class_310.method_1551().method_1507(this.parentScreen)).method_46434(10, 10, 20, 20).method_46431());
        currentY += 20;
        String defaultName = this.litematicFile.getName();
        if (defaultName.toLowerCase().endsWith(".litematic")) {
            defaultName = defaultName.substring(0, defaultName.length() - 10);
        }
        this.nameField = new class_342(this.field_22793, centerX - fieldWidth / 2, currentY, fieldWidth, fieldHeight, (class_2561)class_2561.method_43470((String)""));
        this.nameField.method_1880(50);
        if (!this.currentNameFieldText.isEmpty()) {
            this.nameField.method_1852(this.currentNameFieldText);
        } else {
            this.nameField.method_1852(defaultName);
        }
        this.nameField.method_1863(text -> {
            this.currentNameFieldText = text;
        });
        this.method_25429((class_364)this.nameField);
        int descriptionHeight = 60;
        this.descriptionField = new MultilineTextFieldWidget(this.field_22793, centerX - fieldWidth / 2, currentY += 40, fieldWidth, descriptionHeight, (class_2561)class_2561.method_43470((String)""));
        this.descriptionField.method_1880(2000);
        if (!this.currentDescriptionFieldText.isEmpty()) {
            this.descriptionField.method_1852(this.currentDescriptionFieldText);
        }
        this.descriptionField.method_1863(text -> {
            this.currentDescriptionFieldText = text;
        });
        this.descriptionField.setOnHeightChanged(() -> this.method_25426());
        this.method_25429((class_364)this.descriptionField);
        this.tagsField = new class_342(this.field_22793, centerX - fieldWidth / 2, currentY += this.descriptionField.method_25364() + 20, fieldWidth - 80, fieldHeight, (class_2561)class_2561.method_43470((String)""));
        this.tagsField.method_1880(50);
        if (!this.currentTagsFieldText.isEmpty()) {
            this.tagsField.method_1852(this.currentTagsFieldText);
        }
        this.tagsField.method_1863(text -> {
            this.currentTagsFieldText = text;
            this.tagError = "";
        });
        this.method_25429((class_364)this.tagsField);
        class_4185 addTagButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add Tag"), button -> this.addTagFromField()).method_46434(centerX + fieldWidth / 2 - 75, currentY, 75, 20).method_46431();
        this.method_37063((class_364)addTagButton);
        this.mediaFireField = new class_342(this.field_22793, centerX - fieldWidth / 2, currentY += 80, fieldWidth, fieldHeight, (class_2561)class_2561.method_43470((String)""));
        this.mediaFireField.method_1880(500);
        if (!this.currentMediaFireFieldText.isEmpty()) {
            this.mediaFireField.method_1852(this.currentMediaFireFieldText);
        }
        this.mediaFireField.method_1863(text -> {
            this.currentMediaFireFieldText = text;
            this.validateMediaFireUrl((String)text);
        });
        this.method_25429((class_364)this.mediaFireField);
        this.youtubeField = new class_342(this.field_22793, centerX - fieldWidth / 2, currentY += 40, fieldWidth, fieldHeight, (class_2561)class_2561.method_43470((String)""));
        this.youtubeField.method_1880(500);
        if (!this.currentYoutubeFieldText.isEmpty()) {
            this.youtubeField.method_1852(this.currentYoutubeFieldText);
        }
        this.youtubeField.method_1863(text -> {
            this.currentYoutubeFieldText = text;
            this.validateYoutubeUrl((String)text);
        });
        this.method_25429((class_364)this.youtubeField);
        class_4185 selectImagesButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Select Images (" + this.selectedImages.size() + "/5)")), button -> this.openImageSelector()).method_46434(centerX - 100, currentY += 50, 200, 20).method_46431();
        this.method_37063((class_364)selectImagesButton);
        currentY += 30;
        if (!this.selectedImages.isEmpty()) {
            int previewsPerRow = 4;
            int imageRows = (this.selectedImages.size() + previewsPerRow - 1) / previewsPerRow;
            int totalImageHeight = imageRows * 110 + 10;
            currentY += totalImageHeight;
        }
        class_4185 selectLitematicButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Select Litematic Files (" + this.selectedLitematicFiles.size() + "/5)")), button -> this.openLitematicSelector()).method_46434(centerX - 100, currentY, 200, 20).method_46431();
        this.method_37063((class_364)selectLitematicButton);
        class_4185 previewButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Preview Post"), button -> this.showPreview()).method_46434(centerX - 150, currentY += 40, 95, 20).method_46431();
        this.method_37063((class_364)previewButton);
        this.publishButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.isPublishing ? "Publishing..." : "Publish")), button -> this.publishSchematic()).method_46434(centerX - 47, currentY, 95, 20).method_46431();
        this.publishButton.field_22763 = !this.isPublishing && this.isFormValid();
        this.method_37063((class_364)this.publishButton);
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> class_310.method_1551().method_1507(this.parentScreen)).method_46434(centerX + 55, currentY, 95, 20).method_46431();
        this.method_37063((class_364)cancelButton);
        this.totalContentHeight = currentY + 50 - baseY;
        this.restoreFocus();
    }

    private void restoreFocus() {
        class_310.method_1551().execute(() -> {
            switch (this.focusedFieldType) {
                case "name": {
                    if (this.nameField == null) break;
                    this.method_25395((class_364)this.nameField);
                    this.nameField.method_25365(true);
                    if (this.focusedFieldCursorPosition < 0 || this.focusedFieldCursorPosition > this.nameField.method_1882().length()) break;
                    this.nameField.method_1883(this.focusedFieldCursorPosition, false);
                    break;
                }
                case "description": {
                    if (this.descriptionField == null) break;
                    this.method_25395((class_364)this.descriptionField);
                    this.descriptionField.method_25365(true);
                    if (this.focusedFieldCursorPosition < 0 || this.focusedFieldCursorPosition > this.descriptionField.method_1882().length()) break;
                    this.descriptionField.method_1883(this.focusedFieldCursorPosition, false);
                    break;
                }
                case "tags": {
                    if (this.tagsField == null) break;
                    this.method_25395((class_364)this.tagsField);
                    this.tagsField.method_25365(true);
                    if (this.focusedFieldCursorPosition < 0 || this.focusedFieldCursorPosition > this.tagsField.method_1882().length()) break;
                    this.tagsField.method_1883(this.focusedFieldCursorPosition, false);
                    break;
                }
                case "youtube": {
                    if (this.youtubeField == null) break;
                    this.method_25395((class_364)this.youtubeField);
                    this.youtubeField.method_25365(true);
                    if (this.focusedFieldCursorPosition < 0 || this.focusedFieldCursorPosition > this.youtubeField.method_1882().length()) break;
                    this.youtubeField.method_1883(this.focusedFieldCursorPosition, false);
                    break;
                }
                case "mediafire": {
                    if (this.mediaFireField == null) break;
                    this.method_25395((class_364)this.mediaFireField);
                    this.mediaFireField.method_25365(true);
                    if (this.focusedFieldCursorPosition < 0 || this.focusedFieldCursorPosition > this.mediaFireField.method_1882().length()) break;
                    this.mediaFireField.method_1883(this.focusedFieldCursorPosition, false);
                }
            }
        });
    }

    private void updateScrollbarDimensions() {
        this.scrollAreaX = 50;
        this.scrollAreaY = 50;
        this.scrollAreaWidth = this.field_22789 - 100;
        this.scrollAreaHeight = this.field_22790 - 100;
        if (this.totalContentHeight == 0) {
            this.totalContentHeight = 600;
        }
        this.scrollOffset = this.totalContentHeight <= this.scrollAreaHeight ? 0 : Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
    }

    private void saveCurrentTextFieldValues() {
        if (this.nameField != null) {
            this.currentNameFieldText = this.nameField.method_1882();
        }
        if (this.descriptionField != null) {
            this.currentDescriptionFieldText = this.descriptionField.method_1882();
        }
        if (this.tagsField != null) {
            this.currentTagsFieldText = this.tagsField.method_1882();
        }
        if (this.youtubeField != null) {
            this.currentYoutubeFieldText = this.youtubeField.method_1882();
        }
        if (this.mediaFireField != null) {
            this.currentMediaFireFieldText = this.mediaFireField.method_1882();
        }
        this.focusedFieldType = "";
        if (this.nameField != null && this.nameField.method_25370()) {
            this.focusedFieldType = "name";
        } else if (this.descriptionField != null && this.descriptionField.method_25370()) {
            this.focusedFieldType = "description";
        } else if (this.tagsField != null && this.tagsField.method_25370()) {
            this.focusedFieldType = "tags";
        } else if (this.youtubeField != null && this.youtubeField.method_25370()) {
            this.focusedFieldType = "youtube";
        } else if (this.mediaFireField != null && this.mediaFireField.method_25370()) {
            this.focusedFieldType = "mediafire";
        }
        this.focusedFieldCursorPosition = 0;
        if (this.nameField != null && this.nameField.method_25370()) {
            this.focusedFieldCursorPosition = this.nameField.method_1881();
        } else if (this.descriptionField != null && this.descriptionField.method_25370()) {
            this.focusedFieldCursorPosition = this.descriptionField.method_1881();
        } else if (this.tagsField != null && this.tagsField.method_25370()) {
            this.focusedFieldCursorPosition = this.tagsField.method_1881();
        } else if (this.youtubeField != null && this.youtubeField.method_25370()) {
            this.focusedFieldCursorPosition = this.youtubeField.method_1881();
        } else if (this.mediaFireField != null && this.mediaFireField.method_25370()) {
            this.focusedFieldCursorPosition = this.mediaFireField.method_1881();
        }
    }

    private void validateYoutubeUrl(String url) {
        this.youtubeUrlError = url.trim().isEmpty() ? "" : (!URL_PATTERN.matcher(url.trim()).matches() ? "Must be a valid HTTPS URL" : "");
    }

    private void validateMediaFireUrl(String url) {
        this.mediaFireUrlError = url.trim().isEmpty() ? "" : (!URL_PATTERN.matcher(url.trim()).matches() ? "Must be a valid HTTPS URL" : "");
    }

    private void addTagFromField() {
        String tag = this.tagsField.method_1882().trim();
        this.tagError = "";
        if (tag.isEmpty()) {
            return;
        }
        if (tag.length() > 12) {
            this.tagError = "Tag must be 12 characters or less";
            ToastManager.addToast("Tag must be 12 characters or less", true);
            return;
        }
        if (this.tagBadges.size() >= 5) {
            this.tagError = "Maximum 5 tags allowed";
            ToastManager.addToast("Maximum 5 tags allowed", true);
            return;
        }
        if (this.tagBadges.stream().anyMatch(existing -> existing.equalsIgnoreCase(tag))) {
            this.tagError = "Tag already exists";
            ToastManager.addToast("Tag already exists", true);
            return;
        }
        String formattedTag = this.formatTag(tag);
        this.tagBadges.add(formattedTag);
        this.tagsField.method_1852("");
        this.currentTagsFieldText = "";
        this.method_25426();
    }

    private String formatTag(String tag) {
        if (tag.isEmpty()) {
            return tag;
        }
        String[] words = tag.toLowerCase().split("\\s+");
        StringBuilder formattedTag = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (word.isEmpty()) continue;
            formattedTag.append(word.substring(0, 1).toUpperCase());
            if (word.length() > 1) {
                formattedTag.append(word.substring(1));
            }
            if (i >= words.length - 1) continue;
            formattedTag.append(" ");
        }
        return formattedTag.toString();
    }

    private boolean isFormValid() {
        return !this.nameField.method_1882().trim().isEmpty() && !this.selectedImages.isEmpty() && (this.litematicFile != null || !this.selectedLitematicFiles.isEmpty()) && this.youtubeUrlError.isEmpty() && this.mediaFireUrlError.isEmpty() && this.tagError.isEmpty();
    }

    private void openImageSelector() {
        try {
            if (this.tryNativeImageFileChooser()) {
                return;
            }
            ToastManager.addToast("Cannot open file browser in this environment.", true);
        }
        catch (Exception e) {
            System.err.println("Failed to open file browser: " + e.getMessage());
            ToastManager.addToast("Failed to open file browser: " + e.getMessage(), true);
        }
    }

    private void openLitematicSelector() {
        try {
            if (this.tryNativeLitematicFileChooser()) {
                return;
            }
            ToastManager.addToast("Cannot open file browser in this environment.", true);
        }
        catch (Exception e) {
            System.err.println("Failed to open file browser: " + e.getMessage());
            ToastManager.addToast("Failed to open file browser: " + e.getMessage(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryNativeImageFileChooser() {
        try {
            ProcessBuilder pb;
            String os = System.getProperty("os.name").toLowerCase();
            String currentPath = SettingsManager.getImagesPath();
            System.out.println("Opening image selector at: " + currentPath);
            Process process = null;
            if (os.contains("win")) {
                script = String.format("Add-Type -AssemblyName System.Windows.Forms; $f = New-Object System.Windows.Forms.OpenFileDialog; $f.Title = 'Select Image Files'; $f.InitialDirectory = '%s'; $f.Filter = 'Image files (*.png;*.jpg;*.jpeg;*.gif;*.bmp)|*.png;*.jpg;*.jpeg;*.gif;*.bmp|All files (*.*)|*.*'; $f.Multiselect = $true; if ($f.ShowDialog() -eq 'OK') { $f.FileNames | ForEach-Object { Write-Output $_ } }", currentPath.replace("'", "''"));
                pb = new ProcessBuilder("powershell.exe", "-Command", script);
            } else if (os.contains("mac")) {
                script = String.format("set fileList to choose file with prompt \"Select Image Files\" default location POSIX file \"%s\" of type {\"png\", \"jpg\", \"jpeg\", \"gif\", \"bmp\"} with multiple selections allowed\nrepeat with aFile in fileList\n    set filePath to POSIX path of aFile\n    log filePath\nend repeat", currentPath.replace("\"", "\\\""));
                pb = new ProcessBuilder("osascript", "-e", script);
            } else {
                if (!os.contains("nix")) {
                    if (!os.contains("nux")) return false;
                }
                String[] tools = new String[]{"zenity", "kdialog", "yad"};
                pb = null;
                for (String tool : tools) {
                    if (!this.isCommandAvailable(tool)) continue;
                    try {
                        pb = this.createLinuxImageFileDialog(tool, currentPath);
                        if (pb == null) continue;
                        if (this.testLinuxDialogTool(tool)) break;
                        System.out.println("Tool " + tool + " failed X11 test, trying next...");
                        pb = null;
                    }
                    catch (Exception e) {
                        System.out.println("Tool " + tool + " failed: " + e.getMessage());
                        pb = null;
                    }
                }
                if (pb == null) {
                    System.err.println("No working file dialog tools found on Linux");
                    return false;
                }
            }
            try {
                process = pb.start();
                boolean finished = process.waitFor(30L, TimeUnit.SECONDS);
                if (!finished) {
                    process.destroyForcibly();
                    ToastManager.addToast("File chooser timed out", true);
                    boolean bl = false;
                    return bl;
                }
                this.selectedImages.clear();
                int rejectedCount = 0;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                     BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    String line;
                    String errorLine;
                    System.out.println("Reading file selections:");
                    StringBuilder errors = new StringBuilder();
                    while ((errorLine = errorReader.readLine()) != null) {
                        errors.append(errorLine).append("\n");
                    }
                    if (errors.length() > 0) {
                        System.err.println("File chooser errors: " + errors.toString());
                    }
                    while ((line = reader.readLine()) != null) {
                        System.out.println("Read line: " + line);
                        String filePath = line.trim();
                        if (filePath.isEmpty()) continue;
                        if (os.contains("mac") && filePath.startsWith("alias ")) {
                            filePath = filePath.substring(6);
                        }
                        if ((os.contains("nix") || os.contains("nux")) && filePath.contains("|")) {
                            String[] paths;
                            for (String path : paths = filePath.split("\\|")) {
                                if (this.addImageFile(new File(path.trim()))) continue;
                                ++rejectedCount;
                            }
                            continue;
                        }
                        if (this.addImageFile(new File(filePath))) continue;
                        ++rejectedCount;
                    }
                    int exitCode = process.exitValue();
                    if (exitCode == 0) {
                        System.out.println("Selected " + this.selectedImages.size() + " images");
                        if (rejectedCount > 0) {
                            ToastManager.addToast("Only first 5 images selected. " + rejectedCount + " images were not loaded.", true);
                        } else {
                            ToastManager.addToast("Selected " + this.selectedImages.size() + " image(s)", false);
                        }
                        this.method_25426();
                        boolean bl = true;
                        return bl;
                    }
                    System.err.println("File chooser exited with code: " + exitCode);
                    if (errors.length() > 0) {
                        ToastManager.addToast("File chooser failed: " + errors.toString().substring(0, Math.min(50, errors.length())), true);
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (process != null && process.isAlive()) {
                    try {
                        process.destroyForcibly();
                        process.waitFor(5L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        System.err.println("Error cleaning up image file dialog process: " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Native image file chooser error: " + e.getMessage());
            e.printStackTrace();
            String errorMsg = "File chooser failed";
            if (e.getMessage().contains("X Error") || e.getMessage().contains("BadWindow")) {
                errorMsg = "Display error - try again or restart the application";
            }
            ToastManager.addToast(errorMsg, true);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryNativeLitematicFileChooser() {
        try {
            ProcessBuilder pb;
            String os = System.getProperty("os.name").toLowerCase();
            String currentPath = SettingsManager.getSchematicsPath();
            System.out.println("Opening litematic selector at: " + currentPath);
            Process process = null;
            if (os.contains("win")) {
                script = String.format("Add-Type -AssemblyName System.Windows.Forms; $f = New-Object System.Windows.Forms.OpenFileDialog; $f.Title = 'Select Litematic Files'; $f.InitialDirectory = '%s'; $f.Filter = 'Litematic files (*.litematic)|*.litematic|All files (*.*)|*.*'; $f.Multiselect = $true; if ($f.ShowDialog() -eq 'OK') { $f.FileNames | ForEach-Object { Write-Output $_ } }", currentPath.replace("'", "''"));
                pb = new ProcessBuilder("powershell.exe", "-Command", script);
            } else if (os.contains("mac")) {
                script = String.format("set fileList to choose file with prompt \"Select Litematic Files\" default location POSIX file \"%s\" of type {\"litematic\"} with multiple selections allowed\nrepeat with aFile in fileList\n    set filePath to POSIX path of aFile\n    log filePath\nend repeat", currentPath.replace("\"", "\\\""));
                pb = new ProcessBuilder("osascript", "-e", script);
            } else {
                if (!os.contains("nix")) {
                    if (!os.contains("nux")) return false;
                }
                String[] tools = new String[]{"zenity", "kdialog", "yad"};
                pb = null;
                for (String tool : tools) {
                    if (!this.isCommandAvailable(tool)) continue;
                    try {
                        pb = this.createLinuxLitematicFileDialog(tool, currentPath);
                        if (pb == null) continue;
                        if (this.testLinuxDialogTool(tool)) break;
                        System.out.println("Tool " + tool + " failed X11 test, trying next...");
                        pb = null;
                    }
                    catch (Exception e) {
                        System.out.println("Tool " + tool + " failed: " + e.getMessage());
                        pb = null;
                    }
                }
                if (pb == null) {
                    System.err.println("No working file dialog tools found on Linux");
                    return false;
                }
            }
            try {
                process = pb.start();
                boolean finished = process.waitFor(30L, TimeUnit.SECONDS);
                if (!finished) {
                    process.destroyForcibly();
                    ToastManager.addToast("Litematic selector timed out", true);
                    boolean bl = false;
                    return bl;
                }
                ArrayList<File> tempSelectedFiles = new ArrayList<File>();
                tempSelectedFiles.add(this.litematicFile);
                int rejectedCount = 0;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                     BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    String line;
                    String errorLine;
                    System.out.println("Reading litematic file selections:");
                    StringBuilder errors = new StringBuilder();
                    while ((errorLine = errorReader.readLine()) != null) {
                        errors.append(errorLine).append("\n");
                    }
                    if (errors.length() > 0) {
                        System.err.println("Litematic selector errors: " + errors.toString());
                    }
                    while ((line = reader.readLine()) != null) {
                        System.out.println("Read line: " + line);
                        String filePath = line.trim();
                        if (filePath.isEmpty()) continue;
                        if (os.contains("mac") && filePath.startsWith("alias ")) {
                            filePath = filePath.substring(6);
                        }
                        if ((os.contains("nix") || os.contains("nux")) && filePath.contains("|")) {
                            String[] paths;
                            for (String path : paths = filePath.split("\\|")) {
                                if (this.addLitematicFile(tempSelectedFiles, new File(path.trim()))) continue;
                                ++rejectedCount;
                            }
                            continue;
                        }
                        if (this.addLitematicFile(tempSelectedFiles, new File(filePath))) continue;
                        ++rejectedCount;
                    }
                    int exitCode = process.exitValue();
                    if (exitCode == 0) {
                        this.selectedLitematicFiles.clear();
                        this.selectedLitematicFiles.addAll(tempSelectedFiles);
                        if (rejectedCount > 0) {
                            ToastManager.addToast("Only first 4 additional files selected. " + rejectedCount + " files were not loaded.", true);
                        } else if (tempSelectedFiles.size() > 1) {
                            ToastManager.addToast("Selected " + (this.selectedLitematicFiles.size() - 1) + " additional litematic file(s)", false);
                        }
                        System.out.println("Selected " + (this.selectedLitematicFiles.size() - 1) + " additional litematic files");
                        this.method_25426();
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (process != null && process.isAlive()) {
                    try {
                        process.destroyForcibly();
                        process.waitFor(5L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        System.err.println("Error cleaning up litematic file dialog process: " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Native litematic file chooser error: " + e.getMessage());
            e.printStackTrace();
            String errorMsg = "Litematic selector failed";
            if (e.getMessage().contains("X Error") || e.getMessage().contains("BadWindow")) {
                errorMsg = "Display error - try again or restart the application";
            }
            ToastManager.addToast(errorMsg, true);
            return false;
        }
    }

    private boolean addImageFile(File file) {
        if (file.exists() && this.isImageFile(file)) {
            if (this.selectedImages.size() >= 5) {
                return false;
            }
            for (File existingImage : this.selectedImages) {
                if (!existingImage.getAbsolutePath().equals(file.getAbsolutePath()) && (!existingImage.getName().equals(file.getName()) || existingImage.length() != file.length())) continue;
                System.out.println("Image already selected (duplicate by path/size): " + file.getAbsolutePath());
                return false;
            }
            System.out.println("Adding image: " + file.getAbsolutePath());
            this.selectedImages.add(file);
            return true;
        }
        return false;
    }

    private boolean isImageFile(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif") || name.endsWith(".bmp") || name.endsWith(".webp");
    }

    private boolean addLitematicFile(List<File> fileList, File file) {
        if (file.exists() && file.getName().toLowerCase().endsWith(".litematic") && !fileList.contains(file)) {
            if (fileList.size() >= 5) {
                return false;
            }
            System.out.println("Adding litematic: " + file.getAbsolutePath());
            fileList.add(file);
            return true;
        }
        return false;
    }

    private ProcessBuilder createLinuxImageFileDialog(String tool, String currentPath) {
        switch (tool) {
            case "zenity": {
                return new ProcessBuilder("zenity", "--file-selection", "--multiple", "--title=Select Image Files", "--filename=" + currentPath + "/", "--file-filter=Image files | *.png *.jpg *.jpeg *.gif *.bmp");
            }
            case "kdialog": {
                return new ProcessBuilder("kdialog", "--getopenmultiplefiles", "--title", "Select Image Files", currentPath, "Image files (*.png *.jpg *.jpeg *.gif *.bmp)");
            }
            case "yad": {
                return new ProcessBuilder("yad", "--file", "--multiple", "--title=Select Image Files", "--filename=" + currentPath + "/", "--file-filter=Image files | *.png *.jpg *.jpeg *.gif *.bmp");
            }
        }
        return null;
    }

    private ProcessBuilder createLinuxLitematicFileDialog(String tool, String currentPath) {
        switch (tool) {
            case "zenity": {
                return new ProcessBuilder("zenity", "--file-selection", "--multiple", "--title=Select Litematic Files", "--filename=" + currentPath + "/", "--file-filter=Litematic files | *.litematic");
            }
            case "kdialog": {
                return new ProcessBuilder("kdialog", "--getopenmultiplefiles", "--title", "Select Litematic Files", currentPath, "Litematic files (*.litematic)");
            }
            case "yad": {
                return new ProcessBuilder("yad", "--file", "--multiple", "--title=Select Litematic Files", "--filename=" + currentPath + "/", "--file-filter=Litematic files | *.litematic");
            }
        }
        return null;
    }

    private boolean isCommandAvailable(String command) {
        try {
            ProcessBuilder pb = new ProcessBuilder("which", command);
            Process process = pb.start();
            return process.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testLinuxDialogTool(String tool) {
        try {
            ProcessBuilder testPb;
            switch (tool) {
                case "zenity": {
                    testPb = new ProcessBuilder("zenity", "--version");
                    break;
                }
                case "kdialog": {
                    testPb = new ProcessBuilder("kdialog", "--version");
                    break;
                }
                case "yad": {
                    testPb = new ProcessBuilder("yad", "--version");
                    break;
                }
                default: {
                    return false;
                }
            }
            testPb.environment().put("DISPLAY", System.getenv("DISPLAY"));
            Process testProcess = testPb.start();
            boolean finished = testProcess.waitFor(3L, TimeUnit.SECONDS);
            if (!finished) {
                testProcess.destroyForcibly();
                return false;
            }
            int exitCode = testProcess.exitValue();
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(testProcess.getErrorStream()));){
                String errorLine;
                while ((errorLine = errorReader.readLine()) != null) {
                    String lowerError = errorLine.toLowerCase();
                    if (!lowerError.contains("x error") && !lowerError.contains("badwindow") && !lowerError.contains("cannot open display") && !lowerError.contains("no display") && !lowerError.contains("connection refused")) continue;
                    System.err.println("X11 error detected in " + tool + ": " + errorLine);
                    boolean bl = false;
                    return bl;
                }
            }
            if (exitCode != 0) return false;
            return true;
        }
        catch (Exception e) {
            System.err.println("Test failed for " + tool + ": " + e.getMessage());
            return false;
        }
    }

    private void showPreview() {
        ToastManager.addToast("Preview feature coming soon!", false);
    }

    /*
     * WARNING - void declaration
     */
    private void publishSchematic() {
        if (this.isPublishing || !this.isFormValid()) {
            return;
        }
        if (!SettingsManager.hasApiToken()) {
            ToastManager.addToast("Please link your account in settings before publishing", true);
            return;
        }
        this.isPublishing = true;
        this.publishButton.method_25355((class_2561)class_2561.method_43470((String)"Publishing..."));
        this.publishButton.field_22763 = false;
        try {
            void var3_10;
            void var3_8;
            Object file;
            System.out.println("=== PUBLISH SCHEMATIC DEBUG START ===");
            System.out.println("Original litematic file (from constructor): " + this.litematicFile.getName() + " (" + this.litematicFile.getAbsolutePath() + ")");
            System.out.println("selectedLitematicFiles list contains " + this.selectedLitematicFiles.size() + " files:");
            for (int i2 = 0; i2 < this.selectedLitematicFiles.size(); ++i2) {
                file = this.selectedLitematicFiles.get(i2);
                System.out.println("  [" + i2 + "] " + ((File)file).getName() + " (" + ((File)file).getAbsolutePath() + ")");
                System.out.println("      equals(litematicFile): " + ((File)file).equals(this.litematicFile));
                System.out.println("      same path: " + ((File)file).getAbsolutePath().equals(this.litematicFile.getAbsolutePath()));
            }
            System.out.println("selectedImages list contains " + this.selectedImages.size() + " files:");
            for (int i = 0; i < this.selectedImages.size(); ++i) {
                file = this.selectedImages.get(i);
                System.out.println("  [" + i + "] " + ((File)file).getName() + " (" + ((File)file).getAbsolutePath() + ")");
            }
            ArrayList<File> litematicFilesToSend = new ArrayList<File>();
            System.out.println("Starting litematic cleanup process...");
            litematicFilesToSend.add(this.litematicFile);
            System.out.println("Added original litematic file: " + this.litematicFile.getName());
            System.out.println("Checking selectedLitematicFiles for additional files...");
            for (File file2 : this.selectedLitematicFiles) {
                System.out.println("  Checking file: " + file2.getName());
                System.out.println("    equals(litematicFile): " + file2.equals(this.litematicFile));
                System.out.println("    already in litematicFilesToSend: " + litematicFilesToSend.contains(file2));
                if (!file2.equals(this.litematicFile) && !litematicFilesToSend.contains(file2)) {
                    litematicFilesToSend.add(file2);
                    System.out.println("    -> ADDED to litematicFilesToSend");
                    continue;
                }
                System.out.println("    -> SKIPPED (duplicate or original)");
            }
            ArrayList<File> imagesToSend = new ArrayList<File>();
            System.out.println("Starting images cleanup process...");
            for (File image : this.selectedImages) {
                System.out.println("  Checking image: " + image.getName());
                boolean isDuplicate = false;
                for (File existingImage : imagesToSend) {
                    if (!existingImage.getAbsolutePath().equals(image.getAbsolutePath()) && (!existingImage.getName().equals(image.getName()) || existingImage.length() != image.length())) continue;
                    isDuplicate = true;
                    break;
                }
                System.out.println("    already in imagesToSend: " + isDuplicate);
                if (!isDuplicate) {
                    imagesToSend.add(image);
                    System.out.println("    -> ADDED to imagesToSend");
                    continue;
                }
                System.out.println("    -> SKIPPED (duplicate by path/size)");
            }
            System.out.println("FINAL LISTS TO SEND:");
            System.out.println("  - litematicFilesToSend: " + litematicFilesToSend.size() + " files");
            boolean bl = false;
            while (var3_8 < litematicFilesToSend.size()) {
                System.out.println("    [" + (int)var3_8 + "] " + ((File)litematicFilesToSend.get((int)var3_8)).getName());
                ++var3_8;
            }
            System.out.println("  - imagesToSend: " + imagesToSend.size() + " files");
            boolean bl2 = false;
            while (var3_10 < imagesToSend.size()) {
                System.out.println("    [" + (int)var3_10 + "] " + ((File)imagesToSend.get((int)var3_10)).getName());
                ++var3_10;
            }
            System.out.println("  - Cover image index: " + this.selectedCoverImageIndex);
            System.out.println("=== PUBLISH SCHEMATIC DEBUG END ===");
            SchematicCreateDTO schematicCreateDTO = new SchematicCreateDTO(this.nameField.method_1882().trim(), imagesToSend, litematicFilesToSend);
            String description = this.descriptionField.method_1882().trim();
            if (description.isEmpty()) {
                description = "No description provided";
            }
            schematicCreateDTO.setDescription(description);
            String mediaFireUrl = this.mediaFireField.method_1882().trim();
            String youtubeUrl = this.youtubeField.method_1882().trim();
            if (!mediaFireUrl.isEmpty()) {
                schematicCreateDTO.setDownloadLinkMediaFire(mediaFireUrl);
            }
            if (!youtubeUrl.isEmpty()) {
                schematicCreateDTO.setYoutubeLink(youtubeUrl);
            }
            if (!this.tagBadges.isEmpty()) {
                schematicCreateDTO.setTags(String.join((CharSequence)",", this.tagBadges));
            }
            schematicCreateDTO.setCoverImageIndex(this.selectedCoverImageIndex);
            String apiToken = SettingsManager.getApiToken();
            LitematicHttpClient.createSchematic(schematicCreateDTO, apiToken, new LitematicHttpClient.CreateSchematicCallback(){

                @Override
                public void onSuccess(JsonObject responseData) {
                    PublishScreen.this.isPublishing = false;
                    PublishScreen.this.publishButton.method_25355((class_2561)class_2561.method_43470((String)"Publish"));
                    PublishScreen.this.publishButton.field_22763 = true;
                    String schematicName = PublishScreen.this.nameField.method_1882().trim();
                    String schematicId = responseData.has("id") ? responseData.get("id").getAsString() : "unknown";
                    ToastManager.addToast("\u2705 Successfully published \"" + schematicName + "\"!", false);
                    class_310.method_1551().method_1507(PublishScreen.this.parentScreen);
                }

                @Override
                public void onError(String message) {
                    PublishScreen.this.isPublishing = false;
                    PublishScreen.this.publishButton.method_25355((class_2561)class_2561.method_43470((String)"Publish"));
                    PublishScreen.this.publishButton.field_22763 = true;
                    String errorMsg = "Publishing failed: " + message;
                    ToastManager.addToast(errorMsg, true);
                    System.err.println("Publishing error: " + message);
                }
            });
        }
        catch (Exception e) {
            this.isPublishing = false;
            this.publishButton.method_25355((class_2561)class_2561.method_43470((String)"Publish"));
            this.publishButton.field_22763 = true;
            ToastManager.addToast("Error preparing data for publishing: " + e.getMessage(), true);
            System.err.println("Error preparing schematic data: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int baseY;
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_44379(this.scrollAreaX, this.scrollAreaY, this.scrollAreaX + this.scrollAreaWidth, this.scrollAreaY + this.scrollAreaHeight);
        int centerX = this.field_22789 / 2;
        int currentY = baseY = this.scrollAreaY - this.scrollOffset;
        int fieldWidth = 400;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Name"), centerX - 200, (currentY += 20) - 15, -1);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Description"), centerX - 200, (currentY += 40) - 15, -1);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Tags"), centerX - 200, (currentY += this.descriptionField.method_25364() + 20) - 15, -1);
        if (!this.tagError.isEmpty()) {
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)this.tagError), centerX - 200, currentY + 5, -43691);
        }
        int badgeY = currentY += 30;
        if (!this.tagBadges.isEmpty()) {
            int badgeX = centerX - 200;
            for (String tag : this.tagBadges) {
                int badgeWidth = this.field_22793.method_1727(tag) + 16;
                context.method_25294(badgeX, badgeY, badgeX + badgeWidth, badgeY + 16, -11751600);
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)tag), badgeX + 4, badgeY + 4, -1);
                boolean isXHovered = mouseX >= badgeX + badgeWidth - 12 && mouseX <= badgeX + badgeWidth - 4 && mouseY >= badgeY + 4 && mouseY <= badgeY + 12;
                int xColor = isXHovered ? -43691 : -1;
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"\u00d7"), badgeX + badgeWidth - 10, badgeY + 4, xColor);
                if ((badgeX += badgeWidth + 4) <= centerX + 150) continue;
                badgeX = centerX - 200;
                badgeY += 20;
            }
            currentY = badgeY + 30;
        } else {
            currentY += 30;
        }
        int mediaFireLabelY = this.mediaFireField.method_46427() - 15;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"External Download Link"), this.mediaFireField.method_46426(), mediaFireLabelY, -1);
        if (!this.mediaFireUrlError.isEmpty()) {
            int errorX = this.mediaFireField.method_46426() + 270;
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)this.mediaFireUrlError), errorX, mediaFireLabelY, -43691);
        }
        currentY += 40;
        int youtubeLabelY = this.youtubeField.method_46427() - 15;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Video Link"), this.youtubeField.method_46426(), youtubeLabelY, -1);
        if (!this.youtubeUrlError.isEmpty()) {
            int errorX = this.youtubeField.method_46426() + 270;
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)this.youtubeUrlError), errorX, youtubeLabelY, -43691);
        }
        currentY += 50;
        if (!this.selectedImages.isEmpty()) {
            int previewSize = 80;
            int previewsPerRow = 4;
            int previewX = centerX - previewsPerRow * (previewSize + 10) / 2;
            int imageStartY = currentY + 50;
            for (int i = 0; i < this.selectedImages.size(); ++i) {
                Object filename;
                File imageFile = this.selectedImages.get(i);
                int x = previewX + i % previewsPerRow * (previewSize + 10);
                int y = imageStartY + i / previewsPerRow * (previewSize + 30);
                boolean isCover = i == this.selectedCoverImageIndex;
                int borderColor = isCover ? -11751600 : -10066330;
                context.method_25294(x - 2, y - 2, x + previewSize + 2, y + previewSize + 2, borderColor);
                context.method_25294(x, y, x + previewSize, y + previewSize, -13421773);
                class_2960 textureId = this.getImageTexture(imageFile);
                if (textureId != null) {
                    context.method_25290(class_10799.field_56883, textureId, x, y, 0.0f, 0.0f, previewSize, previewSize, previewSize, previewSize);
                } else if (this.failedImages.contains(imageFile)) {
                    context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"ERROR"), x + previewSize / 2, y + previewSize / 2, -65536);
                } else {
                    context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"LOADING"), x + previewSize / 2, y + previewSize / 2, -1);
                }
                if (isCover) {
                    context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"COVER"), x + previewSize / 2, y + previewSize + 5, -11751600);
                }
                if (((String)(filename = imageFile.getName())).length() > 12) {
                    filename = ((String)filename).substring(0, 9) + "...";
                }
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)filename), x + previewSize / 2, y + previewSize + 15, -3355444);
            }
            int imageRows = (this.selectedImages.size() + previewsPerRow - 1) / previewsPerRow;
            int totalImageHeight = imageRows * (previewSize + 30) + 20;
            currentY += totalImageHeight;
        }
        context.method_44380();
        if (this.totalContentHeight > this.scrollAreaHeight) {
            int scrollBarWidth = 6;
            this.scrollBarHeight = Math.max(20, this.scrollAreaHeight * this.scrollAreaHeight / this.totalContentHeight);
            this.scrollBarX = this.scrollAreaX + this.scrollAreaWidth;
            this.scrollBarY = this.scrollAreaY + (int)((float)this.scrollOffset / (float)(this.totalContentHeight - this.scrollAreaHeight) * (float)(this.scrollAreaHeight - this.scrollBarHeight));
            context.method_25294(this.scrollBarX, this.scrollAreaY, this.scrollBarX + scrollBarWidth, this.scrollAreaY + this.scrollAreaHeight, 0x33FFFFFF);
            boolean isHovering = mouseX >= this.scrollBarX && mouseX <= this.scrollBarX + scrollBarWidth && mouseY >= this.scrollBarY && mouseY <= this.scrollBarY + this.scrollBarHeight;
            int scrollBarColor = isHovering || this.isScrolling ? -1 : -1426063361;
            context.method_25294(this.scrollBarX, this.scrollBarY, this.scrollBarX + scrollBarWidth, this.scrollBarY + this.scrollBarHeight, scrollBarColor);
        }
        this.nameField.method_25394(context, mouseX, mouseY, delta);
        this.descriptionField.method_25394(context, mouseX, mouseY, delta);
        this.tagsField.method_25394(context, mouseX, mouseY, delta);
        this.youtubeField.method_25394(context, mouseX, mouseY, delta);
        this.mediaFireField.method_25394(context, mouseX, mouseY, delta);
        ToastManager.render(context, this.field_22789);
    }

    public boolean method_25404(class_11908 input) {
        int key;
        if (this.tagsField != null && this.tagsField.method_25370() && ((key = input.comp_4795()) == 257 || key == 335)) {
            this.addTagFromField();
            return true;
        }
        return super.method_25404(input);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (button == 0) {
            int baseY;
            int centerX = this.field_22789 / 2;
            int currentY = baseY = this.scrollAreaY - this.scrollOffset;
            currentY += 20;
            currentY += 40;
            currentY += this.descriptionField.method_25364() + 20;
            currentY += 30;
            if (!this.tagBadges.isEmpty()) {
                int badgeX = centerX - 200;
                int badgeY = currentY;
                for (String tag : new ArrayList<String>(this.tagBadges)) {
                    int badgeWidth = this.field_22793.method_1727(tag) + 16;
                    if (mouseX >= (double)(badgeX + badgeWidth - 12) && mouseX <= (double)(badgeX + badgeWidth - 4) && mouseY >= (double)(badgeY + 4) && mouseY <= (double)(badgeY + 12)) {
                        this.tagBadges.remove(tag);
                        ToastManager.addToast("Tag \"" + tag + "\" removed", false);
                        this.method_25426();
                        return true;
                    }
                    if ((badgeX += badgeWidth + 4) <= centerX + 150) continue;
                    badgeX = centerX - 200;
                    badgeY += 20;
                }
            }
            if (!this.selectedImages.isEmpty()) {
                int previewSize = 80;
                int previewsPerRow = 4;
                int previewX = centerX - previewsPerRow * (previewSize + 10) / 2;
                int imageStartY = currentY + 170;
                for (int i = 0; i < this.selectedImages.size(); ++i) {
                    int x = previewX + i % previewsPerRow * (previewSize + 10);
                    int y = imageStartY + i / previewsPerRow * (previewSize + 30);
                    if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + previewSize)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + previewSize))) continue;
                    this.selectedCoverImageIndex = i;
                    ToastManager.addToast("Set image " + (i + 1) + " as cover", false);
                    return true;
                }
            }
        }
        if (button == 0 && this.totalContentHeight > this.scrollAreaHeight) {
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                this.isScrolling = true;
                this.lastMouseY = (int)mouseY;
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
                float clickPercent = ((float)mouseY - (float)this.scrollAreaY) / (float)this.scrollAreaHeight;
                this.scrollOffset = (int)(clickPercent * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
                this.method_25426();
                return true;
            }
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        double mouseY = click.comp_4799();
        if (this.isScrolling) {
            if (mouseY != (double)this.lastMouseY) {
                float dragPercentage = (float)(mouseY - (double)this.lastMouseY) / (float)(this.scrollAreaHeight - this.scrollBarHeight);
                int scrollAmount = (int)(dragPercentage * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
                this.lastMouseY = (int)mouseY;
                this.method_25426();
            }
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0) {
            this.isScrolling = false;
        }
        return super.method_25406(click);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.totalContentHeight > this.scrollAreaHeight) {
            this.scrollOffset += verticalAmount > 0.0 ? -20 : 20;
            this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
            this.method_25426();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private class_2960 getImageTexture(File imageFile) {
        if (this.imageTextures.containsKey(imageFile)) {
            return this.imageTextures.get(imageFile);
        }
        if (this.failedImages.contains(imageFile)) {
            return null;
        }
        if (!imageFile.exists()) {
            this.failedImages.add(imageFile);
            return null;
        }
        try {
            class_1011 nativeImage;
            byte[] imageData;
            String uniqueId = UUID.randomUUID().toString().replace("-", "");
            class_2960 textureId = class_2960.method_60655((String)"minecraft", (String)("textures/dynamic/" + uniqueId));
            try (FileInputStream inputStream = new FileInputStream(imageFile);){
                imageData = ((InputStream)inputStream).readAllBytes();
            }
            if (imageData.length == 0) {
                System.err.println("Image file is empty: " + imageFile.getName());
                ToastManager.addToast("Image file is empty: " + imageFile.getName(), true);
                this.failedImages.add(imageFile);
                return null;
            }
            if (imageData.length < 100) {
                System.err.println("Image data too small, likely corrupted: " + imageData.length + " bytes for " + imageFile.getName());
                ToastManager.addToast("Image file too small (corrupted): " + imageFile.getName(), true);
                return this.createAndRegisterPlaceholder(textureId, imageFile, "Image data too small (corrupted)");
            }
            String detectedFormat = this.detectImageFormat(imageData);
            System.out.println("Detected image format for " + imageFile.getName() + ": " + detectedFormat);
            boolean isPlaceholder = false;
            Object placeholderReason = "";
            try {
                byte[] processedImageData = this.convertImageToPng(imageData, detectedFormat);
                nativeImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(processedImageData));
                if (nativeImage.method_4307() <= 0 || nativeImage.method_4323() <= 0) {
                    System.err.println("Invalid image dimensions for " + imageFile.getName() + ": " + nativeImage.method_4307() + "x" + nativeImage.method_4323());
                    ToastManager.addToast("Invalid dimensions: " + imageFile.getName(), true);
                    nativeImage.close();
                    nativeImage = this.createPlaceholderImage(80, 80, "Invalid dimensions");
                    isPlaceholder = true;
                    placeholderReason = "Invalid image dimensions";
                } else if (nativeImage.method_4307() > 4096 || nativeImage.method_4323() > 4096) {
                    System.err.println("Image too large for " + imageFile.getName() + ": " + nativeImage.method_4307() + "x" + nativeImage.method_4323());
                    ToastManager.addToast("Image too large: " + imageFile.getName() + " (" + nativeImage.method_4307() + "x" + nativeImage.method_4323() + ")", true);
                    nativeImage.close();
                    nativeImage = this.createPlaceholderImage(80, 80, "Image too large");
                    isPlaceholder = true;
                    placeholderReason = "Image too large (" + nativeImage.method_4307() + "x" + nativeImage.method_4323() + ")";
                }
            }
            catch (Exception e) {
                System.err.println("Error loading image " + imageFile.getName() + " (corrupted or unsupported format '" + detectedFormat + "'): " + e.getMessage());
                ToastManager.addToast("Could not load " + detectedFormat + " image: " + imageFile.getName() + " - " + this.getSimpleErrorMessage(e.getMessage()), true);
                nativeImage = this.createPlaceholderImage(80, 80, "Image corrupted");
                isPlaceholder = true;
                placeholderReason = "Image corrupted (" + e.getMessage() + ")";
            }
            if (nativeImage != null) {
                class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(() -> "image_" + imageFile.getName(), nativeImage));
                this.imageTextures.put(imageFile, textureId);
                if (isPlaceholder) {
                    System.out.println("Placeholder image created for " + imageFile.getName() + " due to: " + (String)placeholderReason + " (" + nativeImage.method_4307() + "x" + nativeImage.method_4323() + ")");
                } else {
                    System.out.println("Successfully loaded image: " + imageFile.getName() + " (" + detectedFormat + "): " + nativeImage.method_4307() + "x" + nativeImage.method_4323());
                }
                return textureId;
            }
            this.failedImages.add(imageFile);
            return null;
        }
        catch (Exception e) {
            System.err.println("Failed to process image: " + imageFile.getAbsolutePath());
            e.printStackTrace();
            this.failedImages.add(imageFile);
            return null;
        }
    }

    private String detectImageFormat(byte[] imageData) {
        if (imageData.length < 8) {
            return "unknown";
        }
        if (imageData[0] == -119 && imageData[1] == 80 && imageData[2] == 78 && imageData[3] == 71) {
            return "png";
        }
        if (imageData[0] == -1 && imageData[1] == -40 && imageData[2] == -1) {
            return "jpeg";
        }
        if (imageData.length >= 6 && imageData[0] == 71 && imageData[1] == 73 && imageData[2] == 70) {
            return "gif";
        }
        if (imageData[0] == 66 && imageData[1] == 77) {
            return "bmp";
        }
        if (imageData.length >= 12 && imageData[0] == 82 && imageData[1] == 73 && imageData[2] == 70 && imageData[3] == 70 && imageData[8] == 87 && imageData[9] == 69 && imageData[10] == 66 && imageData[11] == 80) {
            return "webp";
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertImageToPng(byte[] imageData, String format) throws Exception {
        if (format.equals("png") || format.equals("unknown")) {
            return imageData;
        }
        if (format.equals("svg")) {
            throw new Exception("SVG format is not supported for conversion");
        }
        if (format.equals("avif") || format.equals("heif")) {
            throw new Exception(format.toUpperCase() + " format is not supported by Java ImageIO");
        }
        try {
            BufferedImage convertedImage;
            BufferedImage bufferedImage;
            block27: {
                bufferedImage = null;
                try (ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(imageData));){
                    Iterator<ImageReader> autoReaders = ImageIO.getImageReaders(iis);
                    if (!autoReaders.hasNext()) break block27;
                    ImageReader reader = autoReaders.next();
                    try {
                        reader.setInput(iis, true, true);
                        bufferedImage = reader.read(0);
                    }
                    finally {
                        reader.dispose();
                    }
                }
                catch (Exception e) {
                    System.out.println("Auto-detect ImageIO read failed for " + format + ": " + e.getMessage());
                }
            }
            if (bufferedImage == null) {
                try {
                    bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
                }
                catch (Exception e) {
                    System.out.println("Standard ImageIO.read failed for " + format + ": " + e.getMessage());
                }
            }
            if (bufferedImage == null && !format.equals("unknown")) {
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(format.toUpperCase());
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(imageData));
                        reader.setInput(iis);
                        bufferedImage = reader.read(0);
                        reader.dispose();
                        iis.close();
                    }
                }
                catch (Exception e) {
                    System.out.println("Alternative ImageIO approach failed for " + format + ": " + e.getMessage());
                }
            }
            if (bufferedImage == null) {
                throw new Exception("Could not decode " + format + " image");
            }
            if (bufferedImage.getType() != 1 && bufferedImage.getType() != 2) {
                convertedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                Graphics2D g2d = convertedImage.createGraphics();
                g2d.drawImage((Image)bufferedImage, 0, 0, null);
                g2d.dispose();
            } else {
                convertedImage = bufferedImage;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean success = ImageIO.write((RenderedImage)convertedImage, "PNG", baos);
            if (!success) {
                throw new Exception("Failed to write PNG output");
            }
            System.out.println("Successfully converted " + format + " to PNG format");
            return baos.toByteArray();
        }
        catch (Exception e) {
            System.err.println("Failed to convert " + format + " image: " + e.getMessage());
            return imageData;
        }
    }

    private String getSimpleErrorMessage(String fullError) {
        if (fullError.contains("Bad PNG Signature")) {
            return "Corrupted PNG file";
        }
        if (fullError.contains("JPEG")) {
            return "JPEG format issue";
        }
        if (fullError.contains("format")) {
            return "Unsupported format";
        }
        if (fullError.contains("signature") || fullError.contains("Signature")) {
            return "Corrupted file";
        }
        return fullError.length() > 30 ? "Image corrupted" : fullError;
    }

    private class_2960 createAndRegisterPlaceholder(class_2960 textureId, File imageFile, String reason) {
        try {
            class_1011 nativeImage = this.createPlaceholderImage(80, 80, reason);
            if (nativeImage != null) {
                class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(() -> "placeholder_" + imageFile.getName(), nativeImage));
                this.imageTextures.put(imageFile, textureId);
                System.out.println("Placeholder image created for " + imageFile.getName() + " due to: " + reason + " (80x80)");
                return textureId;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create placeholder for " + imageFile.getName() + ": " + e.getMessage());
        }
        this.failedImages.add(imageFile);
        return null;
    }

    private class_1011 createPlaceholderImage(int width, int height, String reason) {
        try {
            class_1011 placeholder = new class_1011(class_1011.class_1012.field_4997, width, height, false);
            return placeholder;
        }
        catch (Exception e) {
            System.err.println("Failed to create placeholder image: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void method_25419() {
        for (class_2960 textureId : this.imageTextures.values()) {
            class_310.method_1551().method_1531().method_4615(textureId);
        }
        this.imageTextures.clear();
        super.method_25419();
    }

    @Environment(value=EnvType.CLIENT)
    private static class MultilineTextFieldWidget
    extends class_342 {
        private int lineCount = 1;
        private final int baseHeight;
        private final int lineHeight = 12;
        private final class_327 textRenderer;
        private Runnable onHeightChanged;

        public MultilineTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
            super(textRenderer, x, y, width, height, text);
            this.baseHeight = height;
            this.textRenderer = textRenderer;
        }

        public void setOnHeightChanged(Runnable callback) {
            this.onHeightChanged = callback;
        }

        public boolean method_25404(class_11908 input) {
            int key = input.comp_4795();
            if (key == 257 || key == 335) {
                String currentText = this.method_1882();
                int cursorPos = this.method_1881();
                String newText = currentText.substring(0, cursorPos) + "\n" + currentText.substring(cursorPos);
                this.method_1852(newText);
                this.method_1883(cursorPos + 1, false);
                return true;
            }
            if (key == 259) {
                String currentText = this.method_1882();
                int cursorPos = this.method_1881();
                if (cursorPos > 0 && currentText.charAt(cursorPos - 1) == '\n') {
                    String currentLineContent;
                    String beforeCursor = currentText.substring(0, cursorPos);
                    String afterCursor = currentText.substring(cursorPos);
                    int currentLineStart = beforeCursor.lastIndexOf(10) + 1;
                    int nextLineEnd = afterCursor.indexOf(10);
                    if (nextLineEnd == -1) {
                        nextLineEnd = afterCursor.length();
                    }
                    if ((currentLineContent = currentText.substring(currentLineStart, cursorPos + nextLineEnd)).trim().isEmpty() || currentLineContent.equals("\n")) {
                        String newText = beforeCursor.substring(0, beforeCursor.length() - 1) + afterCursor;
                        this.method_1852(newText);
                        this.method_1883(cursorPos - 1, false);
                        return true;
                    }
                }
            }
            return super.method_25404(input);
        }

        public void method_1852(String text) {
            int oldHeight = this.method_25364();
            super.method_1852(text);
            this.updateHeight();
            if (this.method_25364() != oldHeight && this.onHeightChanged != null) {
                this.onHeightChanged.run();
            }
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int lineY;
            int x = this.method_46426();
            int y = this.method_46427();
            int width = this.method_25368();
            int height = this.method_25364();
            int backgroundColor = -16777216;
            context.method_25294(x - 1, y - 1, x + width + 1, y + height + 1, -6250336);
            context.method_25294(x, y, x + width, y + height, backgroundColor);
            String text = this.method_1882();
            String[] lines = text.split("\n", -1);
            int textX = x + 4;
            int textY = y + 4;
            int textColor = this.field_22763 ? -2039584 : -9408400;
            for (int i = 0; i < lines.length && (lineY = textY + i * 12) + 12 <= y + height; ++i) {
                String line = lines[i];
                if (this.method_25370()) {
                    int cursorPos = this.method_1881();
                    int lineStartPos = 0;
                    for (int j = 0; j < i; ++j) {
                        lineStartPos += lines[j].length() + 1;
                    }
                    int lineEndPos = lineStartPos + line.length();
                    if (cursorPos >= lineStartPos && cursorPos <= lineEndPos) {
                        int cursorInLine = cursorPos - lineStartPos;
                        String beforeCursor = line.substring(0, Math.min(cursorInLine, line.length()));
                        int cursorX = textX + this.textRenderer.method_1727(beforeCursor);
                        context.method_25294(cursorX, lineY, cursorX + 1, lineY + 12, -3092272);
                    }
                }
                context.method_25303(this.textRenderer, line, textX, lineY, textColor);
            }
            if (text.isEmpty() && !this.method_25370()) {
                context.method_25303(this.textRenderer, "Enter description...", textX, textY, -8355712);
            }
        }

        private void updateHeight() {
            String text = this.method_1882();
            this.lineCount = Math.max(1, text.split("\n", -1).length);
            int newHeight = Math.max(this.baseHeight, this.lineCount * 12 + 8);
            this.method_53533(newHeight);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PreviewData {
        public String name;
        public String description;
        public List<String> tags;
        public String videoLink;
        public String externalDownloadLink;
        public List<File> images;
        public int coverImageIndex;
    }
}

